/*
 * Decompiled with CFR 0.152.
 */
package wicket.spring.injection.annot;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import wicket.injection.IFieldValueFactory;
import wicket.proxy.IProxyTargetLocator;
import wicket.proxy.LazyInitProxyFactory;
import wicket.spring.ISpringContextLocator;
import wicket.spring.SpringBeanLocator;
import wicket.spring.injection.annot.SpringBean;

public class AnnotProxyFieldValueFactory
implements IFieldValueFactory {
    private ISpringContextLocator contextLocator;
    private final ConcurrentHashMap<SpringBeanLocator, Object> cache = new ConcurrentHashMap();

    public AnnotProxyFieldValueFactory(ISpringContextLocator contextLocator) {
        if (contextLocator == null) {
            throw new IllegalArgumentException("[contextLocator] argument cannot be null");
        }
        this.contextLocator = contextLocator;
    }

    public Object getFieldValue(Field field, Object fieldOwner) {
        if (field.isAnnotationPresent(SpringBean.class)) {
            SpringBean annot = field.getAnnotation(SpringBean.class);
            SpringBeanLocator locator = new SpringBeanLocator(annot.name(), field.getType(), this.contextLocator);
            if (this.cache.containsKey(locator)) {
                return this.cache.get(locator);
            }
            Object proxy = LazyInitProxyFactory.createProxy(field.getType(), (IProxyTargetLocator)locator);
            this.cache.put(locator, proxy);
            return proxy;
        }
        return null;
    }

    public boolean supportsField(Field field) {
        return field.isAnnotationPresent(SpringBean.class);
    }
}

