/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.ssl.config.impl;

import jakarta.inject.Named;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.harmonysoft.oss.common.ssl.config.SslCertificateConfig;
import tech.harmonysoft.oss.common.ssl.config.SslCertificateConfigProvider;
import tech.harmonysoft.oss.common.ssl.config.impl.RawSslCertificateConfig;
import tech.harmonysoft.oss.common.string.util.StringUtilKt;
import tech.harmonysoft.oss.configurario.client.DelegatingConfigProvider;
import tech.harmonysoft.oss.configurario.client.factory.ConfigProviderFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ltech/harmonysoft/oss/common/ssl/config/impl/SslCertificateConfigProviderImpl;", "Ltech/harmonysoft/oss/common/ssl/config/SslCertificateConfigProvider;", "Ltech/harmonysoft/oss/configurario/client/DelegatingConfigProvider;", "Ltech/harmonysoft/oss/common/ssl/config/SslCertificateConfig;", "factory", "Ltech/harmonysoft/oss/configurario/client/factory/ConfigProviderFactory;", "(Ltech/harmonysoft/oss/configurario/client/factory/ConfigProviderFactory;)V", "harmonysoft-common"})
public final class SslCertificateConfigProviderImpl
extends DelegatingConfigProvider<SslCertificateConfig>
implements SslCertificateConfigProvider {
    public SslCertificateConfigProviderImpl(@NotNull ConfigProviderFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(factory.build(RawSslCertificateConfig.class, SslCertificateConfigProviderImpl::_init_$lambda$0));
    }

    private static final SslCertificateConfig _init_$lambda$0(RawSslCertificateConfig raw) {
        String string;
        if (Intrinsics.areEqual((Object)raw.getDisabled(), (Object)true)) {
            return SslCertificateConfig.NoCertificate.INSTANCE;
        }
        String string2 = raw.getPath();
        if (string2 == null) {
            return SslCertificateConfig.NoCertificate.INSTANCE;
        }
        String path = string2;
        if (StringUtilKt.isNotNullNotBlankEffective(raw.getPassword()) && StringUtilKt.isNotNullNotBlankEffective(raw.getPasswordFilePath())) {
            throw new IllegalArgumentException("only password or password file can be specified for SSL certificate, got the both");
        }
        if (StringUtilKt.isNullOrBlankEffective(raw.getPassword()) && StringUtilKt.isNullOrBlankEffective(raw.getPasswordFilePath())) {
            throw new IllegalArgumentException("password or password file must be specified for SSL certificate");
        }
        if (StringUtilKt.isNotNullNotBlankEffective(raw.getPassword())) {
            string = raw.getPassword();
        } else if (StringUtilKt.isNotNullNotBlankEffective(raw.getPasswordFilePath())) {
            string = FilesKt.readText$default((File)new File(raw.getPasswordFilePath()), null, (int)1, null);
        } else {
            throw new IllegalArgumentException("I can't happen");
        }
        String password = string;
        return new SslCertificateConfig.Certificate(path, password);
    }
}

