package tech.harmonysoft.oss.common

data class MyData(val p1: String, val p2: Int)

fun main() {
    "abcd".toCharArray().forEach {
        println(it.code)
    }
    process3(listOf("ab", "cd"))
}

fun process(i: Int?): Int {
    if (i == null) {
        throw IllegalArgumentException("bla-bla, bad parameter")
    } else {
        val result = process2(i)
        if (result == null) {
            throw IllegalArgumentException("bla-bla, bad return value")
        }
        return result
    }
}

fun process2(i: Int): Int? {
    return null
}

fun process3(input: Collection<String>) {
    val sumOfCodes = input
        // map as 1 -> *
        .flatMap { it.toCharArray().toList() }
        // map as 1 -> 1
        .map { it.code }
        // reduce
        .fold(0) { acc, i ->
            acc + i
        }
    println(sumOfCodes)
}