/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.number;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u0002H\b\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Ltech/harmonysoft/oss/common/number/NumberUtil;", "", "()V", "FLOATING_POINT_SCALE", "", "getFLOATING_POINT_SCALE", "()I", "normalize", "T", "value", "(Ljava/lang/Object;)Ljava/lang/Object;", "round", "", "precision", "NormalizedBigDecimal", "harmonysoft-common"})
public final class NumberUtil {
    @NotNull
    public static final NumberUtil INSTANCE = new NumberUtil();
    private static final int FLOATING_POINT_SCALE;

    private NumberUtil() {
    }

    public final int getFLOATING_POINT_SCALE() {
        return FLOATING_POINT_SCALE;
    }

    public final <T> T normalize(T value2) {
        return (T)(value2 instanceof BigDecimal ? (Object)((BigDecimal)value2).setScale(FLOATING_POINT_SCALE, RoundingMode.HALF_UP) : value2);
    }

    public final double round(double value2, int precision) {
        double multiplier = Math.pow(10.0, precision);
        return (double)MathKt.roundToLong((double)(value2 * multiplier)) / multiplier;
    }

    static {
        String string = System.getProperty("harmonysoft.number.floating.scale");
        FLOATING_POINT_SCALE = string != null ? Integer.parseInt(string) : 6;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0019\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Ltech/harmonysoft/oss/common/number/NumberUtil$NormalizedBigDecimal;", "", "()V", "MINUS_ONE", "Ljava/math/BigDecimal;", "kotlin.jvm.PlatformType", "getMINUS_ONE", "()Ljava/math/BigDecimal;", "ONE", "getONE", "TEN", "getTEN", "ZERO", "getZERO", "harmonysoft-common"})
    public static final class NormalizedBigDecimal {
        @NotNull
        public static final NormalizedBigDecimal INSTANCE = new NormalizedBigDecimal();
        private static final BigDecimal ZERO = INSTANCE.normalize(BigDecimal.ZERO);
        private static final BigDecimal ONE = INSTANCE.normalize(BigDecimal.ONE);
        private static final BigDecimal MINUS_ONE = INSTANCE.normalize(BigDecimal.valueOf(-1L));
        private static final BigDecimal TEN = INSTANCE.normalize(BigDecimal.TEN);

        private NormalizedBigDecimal() {
        }

        public final BigDecimal getZERO() {
            return ZERO;
        }

        public final BigDecimal getONE() {
            return ONE;
        }

        public final BigDecimal getMINUS_ONE() {
            return MINUS_ONE;
        }

        public final BigDecimal getTEN() {
            return TEN;
        }
    }
}

