/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Arrays;
import java.util.Collection;
import org.testng.xml.IPostProcessor;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class OverrideProcessor
implements IPostProcessor {
    private final String[] m_groups;
    private final String[] m_excludedGroups;

    public OverrideProcessor(String[] groups, String[] excludedGroups) {
        this.m_groups = groups;
        this.m_excludedGroups = excludedGroups;
    }

    @Override
    public Collection<XmlSuite> process(Collection<XmlSuite> suites) {
        for (XmlSuite s2 : suites) {
            if (this.m_groups != null && this.m_groups.length > 0) {
                for (XmlTest t : s2.getTests()) {
                    t.setIncludedGroups(Arrays.asList(this.m_groups));
                }
            }
            if (this.m_excludedGroups == null || this.m_excludedGroups.length <= 0) continue;
            for (XmlTest t : s2.getTests()) {
                t.setExcludedGroups(Arrays.asList(this.m_excludedGroups));
            }
        }
        return suites;
    }
}

