/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.IssuerDetails;

@SdkInternalApi
public class IssuerDetailsMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> SIGNKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SignKey").build();
    private static final MarshallingInfo<String> KEYFINGERPRINT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyFingerprint").build();
    private static final IssuerDetailsMarshaller instance = new IssuerDetailsMarshaller();

    public static IssuerDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(IssuerDetails issuerDetails, ProtocolMarshaller protocolMarshaller) {
        if (issuerDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(issuerDetails.getName(), NAME_BINDING);
            protocolMarshaller.marshall(issuerDetails.getSignKey(), SIGNKEY_BINDING);
            protocolMarshaller.marshall(issuerDetails.getKeyFingerprint(), KEYFINGERPRINT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

