/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lambda.model.transform.ImageConfigMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ImageConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private SdkInternalList<String> entryPoint;
    private SdkInternalList<String> command;
    private String workingDirectory;

    public List<String> getEntryPoint() {
        if (this.entryPoint == null) {
            this.entryPoint = new SdkInternalList();
        }
        return this.entryPoint;
    }

    public void setEntryPoint(Collection<String> entryPoint) {
        if (entryPoint == null) {
            this.entryPoint = null;
            return;
        }
        this.entryPoint = new SdkInternalList<String>(entryPoint);
    }

    public ImageConfig withEntryPoint(String ... entryPoint) {
        if (this.entryPoint == null) {
            this.setEntryPoint(new SdkInternalList<String>(entryPoint.length));
        }
        for (String ele : entryPoint) {
            this.entryPoint.add(ele);
        }
        return this;
    }

    public ImageConfig withEntryPoint(Collection<String> entryPoint) {
        this.setEntryPoint(entryPoint);
        return this;
    }

    public List<String> getCommand() {
        if (this.command == null) {
            this.command = new SdkInternalList();
        }
        return this.command;
    }

    public void setCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
            return;
        }
        this.command = new SdkInternalList<String>(command);
    }

    public ImageConfig withCommand(String ... command) {
        if (this.command == null) {
            this.setCommand(new SdkInternalList<String>(command.length));
        }
        for (String ele : command) {
            this.command.add(ele);
        }
        return this;
    }

    public ImageConfig withCommand(Collection<String> command) {
        this.setCommand(command);
        return this;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public ImageConfig withWorkingDirectory(String workingDirectory) {
        this.setWorkingDirectory(workingDirectory);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntryPoint() != null) {
            sb.append("EntryPoint: ").append(this.getEntryPoint()).append(",");
        }
        if (this.getCommand() != null) {
            sb.append("Command: ").append(this.getCommand()).append(",");
        }
        if (this.getWorkingDirectory() != null) {
            sb.append("WorkingDirectory: ").append(this.getWorkingDirectory());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageConfig)) {
            return false;
        }
        ImageConfig other = (ImageConfig)obj;
        if (other.getEntryPoint() == null ^ this.getEntryPoint() == null) {
            return false;
        }
        if (other.getEntryPoint() != null && !other.getEntryPoint().equals(this.getEntryPoint())) {
            return false;
        }
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getWorkingDirectory() == null ^ this.getWorkingDirectory() == null) {
            return false;
        }
        return other.getWorkingDirectory() == null || other.getWorkingDirectory().equals(this.getWorkingDirectory());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntryPoint() == null ? 0 : this.getEntryPoint().hashCode());
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getWorkingDirectory() == null ? 0 : this.getWorkingDirectory().hashCode());
        return hashCode;
    }

    public ImageConfig clone() {
        try {
            return (ImageConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

