/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.AuthenticationConfig;
import java.util.List;

@SdkInternalApi
public class AuthenticationConfigMarshaller {
    private static final MarshallingInfo<Boolean> ISBASICAUTHSUPPORTED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isBasicAuthSupported").build();
    private static final MarshallingInfo<Boolean> ISAPIKEYAUTHSUPPORTED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isApiKeyAuthSupported").build();
    private static final MarshallingInfo<Boolean> ISOAUTH2SUPPORTED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isOAuth2Supported").build();
    private static final MarshallingInfo<Boolean> ISCUSTOMAUTHSUPPORTED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isCustomAuthSupported").build();
    private static final MarshallingInfo<StructuredPojo> OAUTH2DEFAULTS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("oAuth2Defaults").build();
    private static final MarshallingInfo<List> CUSTOMAUTHCONFIGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customAuthConfigs").build();
    private static final AuthenticationConfigMarshaller instance = new AuthenticationConfigMarshaller();

    public static AuthenticationConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(AuthenticationConfig authenticationConfig, ProtocolMarshaller protocolMarshaller) {
        if (authenticationConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(authenticationConfig.getIsBasicAuthSupported(), ISBASICAUTHSUPPORTED_BINDING);
            protocolMarshaller.marshall(authenticationConfig.getIsApiKeyAuthSupported(), ISAPIKEYAUTHSUPPORTED_BINDING);
            protocolMarshaller.marshall(authenticationConfig.getIsOAuth2Supported(), ISOAUTH2SUPPORTED_BINDING);
            protocolMarshaller.marshall(authenticationConfig.getIsCustomAuthSupported(), ISCUSTOMAUTHSUPPORTED_BINDING);
            protocolMarshaller.marshall(authenticationConfig.getOAuth2Defaults(), OAUTH2DEFAULTS_BINDING);
            protocolMarshaller.marshall(authenticationConfig.getCustomAuthConfigs(), CUSTOMAUTHCONFIGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

