/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.tests.validation;

import com.amazonaws.appflow.custom.connector.tests.exceptions.ValidationException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UrlValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlValidator.class);

    private UrlValidator() {
    }

    public static void validate(String inputUrl) {
        if (StringUtils.isBlank(inputUrl)) {
            return;
        }
        try {
            URI uri = new URI(inputUrl);
            if (!"https".equals(uri.getScheme())) {
                String errorMessage = String.format("Invalid protocol in url %s. Only https format is supported", inputUrl);
                throw new ValidationException(errorMessage);
            }
        }
        catch (URISyntaxException e) {
            LOGGER.error("Invalid url format!");
            String errorMessage = String.format("Invalid format for url %s. Please check if if the url syntax is correct and it resolves to a known host.", inputUrl);
            throw new ValidationException(errorMessage);
        }
    }
}

