/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.tests.validation;

import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.ConnectorModes;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.DescribeConnectorConfigurationResponse;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.AuthenticationConfig;
import com.amazonaws.appflow.custom.connector.tests.exceptions.ValidationException;
import com.amazonaws.appflow.custom.connector.tests.validation.UrlValidator;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectorConfigurationResponseValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorConfigurationResponseValidator.class);
    private static final Pattern RESERVED_KEYWORDS_PATTERN = Pattern.compile("([Aa][Ww][Ss]|[Aa][Mm][Aa][Zz][Oo][Nn]|[Aa][Pp][Pp][Ff][Ll][Oo][Ww]).*");
    public static final ImmutableList<String> RESERVED_KEYWORDS = ImmutableList.of("aws", "amazon", "appflow");

    private ConnectorConfigurationResponseValidator() {
    }

    public static void validateConnectorConfiguration(DescribeConnectorConfigurationResponse connectorConfiguration) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (ConnectorConfigurationResponseValidator.checkForReservedKeyWords(connectorConfiguration.connectorName())) {
            validationErrors.add("ConnectorName should not contain these reserved keywords " + RESERVED_KEYWORDS);
        }
        if (ConnectorConfigurationResponseValidator.checkForReservedKeyWords(connectorConfiguration.connectorOwner())) {
            validationErrors.add("ConnectorOwner should not contain these reserved keywords " + RESERVED_KEYWORDS);
        }
        if (CollectionUtils.isEmpty(connectorConfiguration.connectorModes())) {
            validationErrors.add("ConnectorModes cannot be null for Connector.");
        }
        validationErrors.addAll(ConnectorConfigurationResponseValidator.validateAuthenticationConfig(connectorConfiguration.authenticationConfig()));
        if (connectorConfiguration.connectorModes().contains((Object)ConnectorModes.DESTINATION) && CollectionUtils.isEmpty(connectorConfiguration.supportedWriteOperations())) {
            validationErrors.add("SupportedWriteOperations cannot be null for the connector which supports usage as Destination.");
        }
        if (CollectionUtils.isEmpty(connectorConfiguration.supportedApiVersions())) {
            validationErrors.add("SupportedAPIVersion cannot be null for the connector");
        }
        if (CollectionUtils.isEmpty(connectorConfiguration.operatorsSupported())) {
            validationErrors.add("SupportedOperators cannot be null for the connector");
        }
        if (CollectionUtils.isEmpty(connectorConfiguration.supportedTriggerTypes())) {
            validationErrors.add("SupportedTriggerTypes cannot be null for the connector");
        }
        validationErrors.addAll(ConnectorConfigurationResponseValidator.validateUrls(Collections.singletonList(connectorConfiguration.logoURL())));
        if (CollectionUtils.isNotEmpty(validationErrors)) {
            String errorMessage = "ConnectorConfiguration from the connector failed with following validation validationErrors. " + validationErrors;
            throw new ValidationException(errorMessage);
        }
    }

    private static boolean checkForReservedKeyWords(String input) {
        Matcher matcher = RESERVED_KEYWORDS_PATTERN.matcher(input);
        return matcher.matches();
    }

    private static List<String> validateAuthenticationConfig(AuthenticationConfig authenticationConfig) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!ConnectorConfigurationResponseValidator.isNullOrFalse(authenticationConfig.isCustomAuthSupported()) && CollectionUtils.isEmpty(authenticationConfig.customAuthConfig())) {
            validationErrors.add("For custom Authentication, CustomAuthConfig is required.");
        }
        if (ConnectorConfigurationResponseValidator.isNullOrFalse(authenticationConfig.isCustomAuthSupported()) && CollectionUtils.isNotEmpty(authenticationConfig.customAuthConfig())) {
            validationErrors.add("CustomAuthConfig can only be provided for CustomAuthentication.");
        }
        if (!ConnectorConfigurationResponseValidator.isNullOrFalse(authenticationConfig.isOAuth2Supported()) && Objects.isNull(authenticationConfig.oAuth2Defaults())) {
            validationErrors.add("For OAuth2 Authentication, OAuth2Defaults cannot be null.");
        }
        if (ConnectorConfigurationResponseValidator.isNullOrFalse(authenticationConfig.isOAuth2Supported()) && Objects.nonNull(authenticationConfig.oAuth2Defaults())) {
            validationErrors.add("OAuth2Defaults can only be provided for OAuth2 Authentication.");
        }
        if (!ConnectorConfigurationResponseValidator.isNullOrFalse(authenticationConfig.isOAuth2Supported()) && Objects.nonNull(authenticationConfig.oAuth2Defaults())) {
            validationErrors.addAll(ConnectorConfigurationResponseValidator.validateUrls(authenticationConfig.oAuth2Defaults().tokenURL()));
            if (CollectionUtils.isNotEmpty(authenticationConfig.oAuth2Defaults().authURL())) {
                validationErrors.addAll(ConnectorConfigurationResponseValidator.validateUrls(authenticationConfig.oAuth2Defaults().authURL()));
            }
        }
        return validationErrors;
    }

    private static List<String> validateUrls(List<String> urls) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        urls.forEach(it -> {
            try {
                UrlValidator.validate(it);
            }
            catch (ValidationException ex) {
                validationErrors.add("Validation failed for url " + it + " with errorMessage " + ex.getMessage());
            }
        });
        return validationErrors;
    }

    private static boolean isNullOrFalse(Boolean input) {
        if (Objects.isNull(input)) {
            return true;
        }
        return input == false;
    }
}

