/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.tests.invokers;

import com.amazonaws.appflow.custom.connector.lambda.handler.BaseLambdaConnectorHandler;
import com.amazonaws.appflow.custom.connector.model.ConnectorContext;
import com.amazonaws.appflow.custom.connector.model.ImmutableConnectorContext;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.DescribeConnectorConfigurationResponse;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.ImmutableDescribeConnectorConfigurationRequest;
import com.amazonaws.appflow.custom.connector.model.credentials.ImmutableValidateCredentialsRequest;
import com.amazonaws.appflow.custom.connector.model.credentials.ValidateCredentialsResponse;
import com.amazonaws.appflow.custom.connector.model.metadata.DescribeEntityResponse;
import com.amazonaws.appflow.custom.connector.model.metadata.ImmutableDescribeEntityRequest;
import com.amazonaws.appflow.custom.connector.model.metadata.ImmutableListEntitiesRequest;
import com.amazonaws.appflow.custom.connector.model.metadata.ListEntitiesResponse;
import com.amazonaws.appflow.custom.connector.model.query.ImmutableQueryDataRequest;
import com.amazonaws.appflow.custom.connector.model.query.QueryDataResponse;
import com.amazonaws.appflow.custom.connector.model.retreive.ImmutableRetrieveDataRequest;
import com.amazonaws.appflow.custom.connector.model.retreive.RetrieveDataResponse;
import com.amazonaws.appflow.custom.connector.model.settings.ConnectorRuntimeSettingScope;
import com.amazonaws.appflow.custom.connector.model.settings.ImmutableValidateConnectorRuntimeSettingsRequest;
import com.amazonaws.appflow.custom.connector.model.settings.ValidateConnectorRuntimeSettingsResponse;
import com.amazonaws.appflow.custom.connector.model.write.ImmutableWriteDataRequest;
import com.amazonaws.appflow.custom.connector.model.write.WriteDataResponse;
import com.amazonaws.appflow.custom.connector.tests.invokers.ConnectorTestInvoker;
import com.amazonaws.appflow.custom.connector.tests.model.QueryRecordConfiguration;
import com.amazonaws.appflow.custom.connector.tests.model.RetrieveRecordConfiguration;
import com.amazonaws.appflow.custom.connector.tests.model.TestConfig;
import com.amazonaws.appflow.custom.connector.tests.model.WriteRecordConfiguration;
import com.amazonaws.appflow.custom.connector.tests.resources.TestContext;
import com.amazonaws.appflow.custom.connector.tests.validation.ConnectorConfigurationResponseValidator;
import com.amazonaws.appflow.custom.connector.util.CustomObjectMapper;
import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseConnectorTestInvoker
implements ConnectorTestInvoker {
    private final Logger log = LoggerFactory.getLogger(BaseConnectorTestInvoker.class);
    private final ObjectMapper mapper = CustomObjectMapper.getObjectMapper();
    private final Context testContext = new TestContext();
    private static final String API_VERSION = "api_version";
    private BaseLambdaConnectorHandler connectorHandler;
    private TestConfig testConfig;

    public BaseConnectorTestInvoker(BaseLambdaConnectorHandler connectorHandler, TestConfig testConfig) {
        this.connectorHandler = connectorHandler;
        this.testConfig = testConfig;
    }

    @Override
    public void invokeConfigurationHandlerTests() {
        this.log.info("-----------Starting verification tests for Configuration Handler-----------");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ValidateConnectorRuntimeSettingsResponse validateRuntimeResponse;
            ImmutableValidateConnectorRuntimeSettingsRequest validateRuntimeRequest;
            TestConfig.RuntimeSettings runtimeSettings = this.testConfig.getRuntimeSettings();
            if (!Objects.isNull(runtimeSettings.getConnectorProfile())) {
                this.log.info("Testing ValidateConnectorRuntimeSettings for ConnectorProfile...");
                validateRuntimeRequest = ImmutableValidateConnectorRuntimeSettingsRequest.builder().connectorRuntimeSettings(runtimeSettings.getConnectorProfile()).scope(ConnectorRuntimeSettingScope.CONNECTOR_PROFILE).build();
                this.connectorHandler.handleRequest(this.getInputStream(validateRuntimeRequest), out, this.testContext);
                validateRuntimeResponse = this.mapper.readValue(out.toByteArray(), ValidateConnectorRuntimeSettingsResponse.class);
                out.reset();
                Preconditions.checkNotNull(validateRuntimeResponse);
                Preconditions.checkState(validateRuntimeResponse.isSuccess(), "Validate Connector Runtime response was unsuccessful for the provided TestConfiguration");
            }
            if (!Objects.isNull(runtimeSettings.getSource())) {
                this.log.info("Testing ValidateConnectorRuntimeSettings for Source...");
                validateRuntimeRequest = ImmutableValidateConnectorRuntimeSettingsRequest.builder().connectorRuntimeSettings(runtimeSettings.getSource()).scope(ConnectorRuntimeSettingScope.SOURCE).build();
                this.connectorHandler.handleRequest(this.getInputStream(validateRuntimeRequest), out, this.testContext);
                validateRuntimeResponse = this.mapper.readValue(out.toByteArray(), ValidateConnectorRuntimeSettingsResponse.class);
                out.reset();
                Preconditions.checkNotNull(validateRuntimeResponse);
                Preconditions.checkState(validateRuntimeResponse.isSuccess(), "Validate Connector Runtime response was unsuccessful for the provided TestConfiguration");
            }
            if (!Objects.isNull(runtimeSettings.getDestination())) {
                this.log.info("Testing ValidateConnectorRuntimeSettings for Destination...");
                validateRuntimeRequest = ImmutableValidateConnectorRuntimeSettingsRequest.builder().connectorRuntimeSettings(runtimeSettings.getDestination()).scope(ConnectorRuntimeSettingScope.DESTINATION).build();
                this.connectorHandler.handleRequest(this.getInputStream(validateRuntimeRequest), out, this.testContext);
                validateRuntimeResponse = this.mapper.readValue(out.toByteArray(), ValidateConnectorRuntimeSettingsResponse.class);
                out.reset();
                Preconditions.checkNotNull(validateRuntimeResponse);
                Preconditions.checkState(validateRuntimeResponse.isSuccess(), "Validate Connector Runtime response was unsuccessful for the provided TestConfiguration");
            }
            this.log.info("Testing ValidateCredentials...");
            ImmutableValidateCredentialsRequest validateCredentialsRequest = ImmutableValidateCredentialsRequest.builder().credentials(this.testConfig.getCredentials()).connectorRuntimeSettings(this.buildConnectorRuntimeSettingsMap()).build();
            this.connectorHandler.handleRequest(this.getInputStream(validateCredentialsRequest), out, this.testContext);
            ValidateCredentialsResponse validateCredentialsResponse = this.mapper.readValue(out.toByteArray(), ValidateCredentialsResponse.class);
            out.reset();
            Preconditions.checkNotNull(validateCredentialsResponse);
            Preconditions.checkState(validateCredentialsResponse.isSuccess(), "Validate Credentials response was unsuccessful for the provided TestConfiguration");
            this.log.info("Testing DescribeConnectorConfiguration...");
            ImmutableDescribeConnectorConfigurationRequest describeConnectorRequest = ImmutableDescribeConnectorConfigurationRequest.builder().build();
            this.connectorHandler.handleRequest(this.getInputStream(describeConnectorRequest), out, this.testContext);
            DescribeConnectorConfigurationResponse describeConnectorResponse = this.mapper.readValue(out.toByteArray(), DescribeConnectorConfigurationResponse.class);
            out.reset();
            Preconditions.checkNotNull(describeConnectorResponse);
            Preconditions.checkState(describeConnectorResponse.isSuccess(), "Describe Connector response was unsuccessful");
            Preconditions.checkNotNull(describeConnectorResponse.connectorName());
            Preconditions.checkNotNull(describeConnectorResponse.connectorOwner());
            Preconditions.checkNotNull(describeConnectorResponse.connectorVersion());
            ConnectorConfigurationResponseValidator.validateConnectorConfiguration(describeConnectorResponse);
            this.log.info("Configuration handler was verified successfully!");
        }
        catch (Exception e) {
            this.log.error("Error encountered during ConfigurationHandler verification!", e);
            this.log.error("Verification tests failed for the given Connector Handler. See logs for details");
            System.exit(1);
        }
    }

    @Override
    public void invokeMetadataHandlerTests() {
        this.log.info("-----------Starting verification tests for Metadata Handler-----------");
        try {
            this.log.info("Testing ListEntities...");
            ImmutableListEntitiesRequest listEntitiesRequest = ImmutableListEntitiesRequest.builder().connectorContext(ImmutableConnectorContext.builder().connectorRuntimeSettings(this.buildConnectorRuntimeSettingsMap()).credentials(this.testConfig.getCredentials()).apiVersion(this.testConfig.getRuntimeSettings().getConnectorProfile().get(API_VERSION)).build()).entitiesPath(this.testConfig.getTestEntityIdentifier()).build();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.connectorHandler.handleRequest(this.getInputStream(listEntitiesRequest), out, this.testContext);
            ListEntitiesResponse listEntitiesResponse = this.mapper.readValue(out.toByteArray(), ListEntitiesResponse.class);
            Preconditions.checkNotNull(listEntitiesResponse);
            Preconditions.checkState(listEntitiesResponse.isSuccess(), "List Entities response returned unsuccessful response for the provided TestConfiguration");
            Preconditions.checkNotNull(listEntitiesResponse.entities(), "No entities were returned");
            Preconditions.checkState(!listEntitiesResponse.entities().isEmpty(), "No entities were returned in List Entities response");
            this.log.info("Testing DescribeEntity...");
            ImmutableDescribeEntityRequest describeEntityRequest = ImmutableDescribeEntityRequest.builder().entityIdentifier(this.testConfig.getTestEntityIdentifier()).connectorContext(ImmutableConnectorContext.builder().connectorRuntimeSettings(this.buildConnectorRuntimeSettingsMap()).credentials(this.testConfig.getCredentials()).apiVersion(this.testConfig.getRuntimeSettings().getConnectorProfile().get(API_VERSION)).build()).build();
            out.reset();
            this.connectorHandler.handleRequest(this.getInputStream(describeEntityRequest), out, this.testContext);
            DescribeEntityResponse describeEntityResponse = this.mapper.readValue(out.toByteArray(), DescribeEntityResponse.class);
            Preconditions.checkNotNull(describeEntityResponse);
            Preconditions.checkState(describeEntityResponse.isSuccess(), "Describe Entity response returned unsuccessful response for the provided TestConfiguration");
            Preconditions.checkNotNull(describeEntityResponse.entityDefinition());
            this.log.info("Metadata handler verification was successful!");
        }
        catch (Exception e) {
            this.log.error("Error encountered during MetadataHandler verification!", e);
            this.log.error("Verification tests failed for the given Connector Handler. See logs for details");
            System.exit(1);
        }
    }

    @Override
    public void invokeRecordHandlerTests() {
        this.log.info("-----------Starting verification tests for Record Handler-----------");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int configurationIndex;
            for (configurationIndex = 0; configurationIndex < this.testConfig.getRetrieveRecordConfigurations().size(); ++configurationIndex) {
                this.log.info("Testing RetrieveData configuration " + (configurationIndex + 1) + "...");
                RetrieveRecordConfiguration retrieveRecordConfiguration = this.testConfig.getRetrieveRecordConfigurations().get(configurationIndex);
                ImmutableRetrieveDataRequest retrieveDataRequest = ImmutableRetrieveDataRequest.builder().connectorContext(this.buildTestConfigConnectorContext(retrieveRecordConfiguration.getEntityIdentifier())).entityIdentifier(this.testConfig.getTestEntityIdentifier()).selectedFieldNames(retrieveRecordConfiguration.getSelectedFieldNames()).idFieldName(retrieveRecordConfiguration.getIdFieldName()).ids(retrieveRecordConfiguration.getIds()).build();
                this.connectorHandler.handleRequest(this.getInputStream(retrieveDataRequest), out, this.testContext);
                RetrieveDataResponse retrieveDataResponse = this.mapper.readValue(out.toByteArray(), RetrieveDataResponse.class);
                Preconditions.checkNotNull(retrieveDataResponse);
                Preconditions.checkState(retrieveDataResponse.isSuccess(), "Retrieve Data response returned unsuccessful response for the provided TestConfiguration");
                Preconditions.checkNotNull(retrieveDataResponse.records(), "No records were found");
                Preconditions.checkState(!retrieveDataResponse.records().isEmpty(), "Retrieve Data returned empty record list when at least 1 expected");
                out.reset();
            }
            for (configurationIndex = 0; configurationIndex < this.testConfig.getWriteRecordConfigurations().size(); ++configurationIndex) {
                this.log.info("Testing WriteData configuration " + (configurationIndex + 1) + "...");
                WriteRecordConfiguration writeRecordConfiguration = this.testConfig.getWriteRecordConfigurations().get(configurationIndex);
                ImmutableWriteDataRequest writeDataRequest = ImmutableWriteDataRequest.builder().entityIdentifier(this.testConfig.getTestEntityIdentifier()).operation(writeRecordConfiguration.getOperation()).records(writeRecordConfiguration.getRecords()).idFieldNames(writeRecordConfiguration.getIdFieldNames()).allOrNone(writeRecordConfiguration.isAllOrNone()).connectorContext(this.buildTestConfigConnectorContext(writeRecordConfiguration.getEntityIdentifier())).build();
                this.connectorHandler.handleRequest(this.getInputStream(writeDataRequest), out, this.testContext);
                WriteDataResponse writeDataResponse = this.mapper.readValue(out.toByteArray(), WriteDataResponse.class);
                Preconditions.checkNotNull(writeDataResponse);
                Preconditions.checkState(writeDataResponse.isSuccess(), "Write Data response returned unsuccessful response for the provided TestConfig");
                out.reset();
            }
            for (configurationIndex = 0; configurationIndex < this.testConfig.getQueryRecordConfigurations().size(); ++configurationIndex) {
                this.log.info("Testing QueryData configuration " + (configurationIndex + 1) + "...");
                QueryRecordConfiguration queryRecordConfiguration = this.testConfig.getQueryRecordConfigurations().get(configurationIndex);
                ImmutableQueryDataRequest queryDataRequest = ImmutableQueryDataRequest.builder().entityIdentifier(this.testConfig.getTestEntityIdentifier()).selectedFieldNames(queryRecordConfiguration.getSelectedFieldNames()).filterExpression(queryRecordConfiguration.getFilterExpression()).connectorContext(this.buildTestConfigConnectorContext(queryRecordConfiguration.getEntityIdentifier())).build();
                this.connectorHandler.handleRequest(this.getInputStream(queryDataRequest), out, this.testContext);
                QueryDataResponse queryDataResponse = this.mapper.readValue(out.toByteArray(), QueryDataResponse.class);
                Preconditions.checkNotNull(queryDataResponse);
                Preconditions.checkState(queryDataResponse.isSuccess(), "Query Data response returned unsuccessful response for provided TestConfig");
                Preconditions.checkState(!queryDataResponse.records().isEmpty(), "No records were returned for the given query");
                out.reset();
            }
            this.log.info("Record handler verification was successful!");
        }
        catch (Exception e) {
            this.log.error("Error encountered during RecordHandler verification!", e);
            this.log.error("Verification tests failed for the given Connector Handler. See logs for details");
            System.exit(1);
        }
    }

    private InputStream getInputStream(Object input) throws JsonProcessingException {
        return new ByteArrayInputStream(this.mapper.writeValueAsBytes(input));
    }

    private Map<String, String> buildConnectorRuntimeSettingsMap() {
        HashMap<String, String> connectorRuntimeSettings = new HashMap<String, String>();
        TestConfig.RuntimeSettings runtimeSettings = this.testConfig.getRuntimeSettings();
        if (!Objects.isNull(runtimeSettings.getConnectorProfile())) {
            connectorRuntimeSettings.putAll(runtimeSettings.getConnectorProfile());
        }
        if (!Objects.isNull(runtimeSettings.getSource())) {
            connectorRuntimeSettings.putAll(runtimeSettings.getSource());
        }
        if (!Objects.isNull(runtimeSettings.getDestination())) {
            connectorRuntimeSettings.putAll(runtimeSettings.getDestination());
        }
        return connectorRuntimeSettings;
    }

    private ConnectorContext buildTestConfigConnectorContext(String entityIdentifier) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImmutableDescribeEntityRequest describeEntityRequest = ImmutableDescribeEntityRequest.builder().entityIdentifier(entityIdentifier).connectorContext(ImmutableConnectorContext.builder().connectorRuntimeSettings(this.buildConnectorRuntimeSettingsMap()).credentials(this.testConfig.getCredentials()).apiVersion(this.testConfig.getRuntimeSettings().getConnectorProfile().get(API_VERSION)).build()).build();
        this.connectorHandler.handleRequest(this.getInputStream(describeEntityRequest), out, this.testContext);
        DescribeEntityResponse describeEntityResponse = this.mapper.readValue(out.toByteArray(), DescribeEntityResponse.class);
        return ImmutableConnectorContext.builder().connectorRuntimeSettings(this.buildConnectorRuntimeSettingsMap()).credentials(this.testConfig.getCredentials()).apiVersion(this.testConfig.getRuntimeSettings().getConnectorProfile().get(API_VERSION)).entityDefinition(describeEntityResponse.entityDefinition()).build();
    }
}

