/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.credentials;

import com.amazonaws.appflow.custom.connector.model.credentials.Credentials;
import com.amazonaws.appflow.custom.connector.model.credentials.ValidateCredentialsRequest;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@JsonTypeName(value="ValidateCredentialsRequest")
@Generated(from="ValidateCredentialsRequest", generator="Immutables")
@Immutable
public final class ImmutableValidateCredentialsRequest
implements ValidateCredentialsRequest {
    @Nullable
    private final Map<String, String> connectorRuntimeSettings;
    private final Credentials credentials;

    private ImmutableValidateCredentialsRequest(@Nullable Map<String, String> connectorRuntimeSettings, Credentials credentials) {
        this.connectorRuntimeSettings = connectorRuntimeSettings;
        this.credentials = credentials;
    }

    @Override
    @JsonProperty(value="connectorRuntimeSettings")
    @Nullable
    public Map<String, String> connectorRuntimeSettings() {
        return this.connectorRuntimeSettings;
    }

    @Override
    @JsonProperty(value="credentials")
    public Credentials credentials() {
        return this.credentials;
    }

    public final ImmutableValidateCredentialsRequest withConnectorRuntimeSettings(@Nullable Map<String, ? extends String> entries) {
        if (this.connectorRuntimeSettings == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableValidateCredentialsRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutableValidateCredentialsRequest(newValue, this.credentials);
    }

    public final ImmutableValidateCredentialsRequest withCredentials(Credentials value) {
        if (this.credentials == value) {
            return this;
        }
        Credentials newValue = Objects.requireNonNull(value, "credentials");
        return new ImmutableValidateCredentialsRequest(this.connectorRuntimeSettings, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValidateCredentialsRequest && this.equalTo(0, (ImmutableValidateCredentialsRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableValidateCredentialsRequest another) {
        return Objects.equals(this.connectorRuntimeSettings, another.connectorRuntimeSettings) && this.credentials.equals(another.credentials);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.connectorRuntimeSettings);
        h2 += (h2 << 5) + this.credentials.hashCode();
        return h2;
    }

    public String toString() {
        return "ValidateCredentialsRequest{connectorRuntimeSettings=" + this.connectorRuntimeSettings + ", credentials=" + this.credentials + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableValidateCredentialsRequest fromJson(Json json) {
        Builder builder = ImmutableValidateCredentialsRequest.builder();
        if (json.connectorRuntimeSettings != null) {
            builder.putAllConnectorRuntimeSettings(json.connectorRuntimeSettings);
        }
        if (json.credentials != null) {
            builder.credentials(json.credentials);
        }
        return builder.build();
    }

    public static ImmutableValidateCredentialsRequest copyOf(ValidateCredentialsRequest instance) {
        if (instance instanceof ImmutableValidateCredentialsRequest) {
            return (ImmutableValidateCredentialsRequest)instance;
        }
        return ImmutableValidateCredentialsRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ValidateCredentialsRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CREDENTIALS = 1L;
        private long initBits = 1L;
        private Map<String, String> connectorRuntimeSettings = null;
        @Nullable
        private Credentials credentials;

        private Builder() {
        }

        public final Builder from(ValidateCredentialsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            Map<String, String> connectorRuntimeSettingsValue = instance.connectorRuntimeSettings();
            if (connectorRuntimeSettingsValue != null) {
                this.putAllConnectorRuntimeSettings(connectorRuntimeSettingsValue);
            }
            this.credentials(instance.credentials());
            return this;
        }

        public final Builder putConnectorRuntimeSettings(String key, String value) {
            if (this.connectorRuntimeSettings == null) {
                this.connectorRuntimeSettings = new LinkedHashMap<String, String>();
            }
            this.connectorRuntimeSettings.put(Objects.requireNonNull(key, "connectorRuntimeSettings key"), Objects.requireNonNull(value, "connectorRuntimeSettings value"));
            return this;
        }

        public final Builder putConnectorRuntimeSettings(Map.Entry<String, ? extends String> entry) {
            if (this.connectorRuntimeSettings == null) {
                this.connectorRuntimeSettings = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.connectorRuntimeSettings.put(Objects.requireNonNull(k, "connectorRuntimeSettings key"), Objects.requireNonNull(v, "connectorRuntimeSettings value"));
            return this;
        }

        @JsonProperty(value="connectorRuntimeSettings")
        public final Builder connectorRuntimeSettings(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.connectorRuntimeSettings = null;
                return this;
            }
            this.connectorRuntimeSettings = new LinkedHashMap<String, String>();
            return this.putAllConnectorRuntimeSettings(entries);
        }

        public final Builder putAllConnectorRuntimeSettings(Map<String, ? extends String> entries) {
            if (this.connectorRuntimeSettings == null) {
                this.connectorRuntimeSettings = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.connectorRuntimeSettings.put(Objects.requireNonNull(k, "connectorRuntimeSettings key"), Objects.requireNonNull(v, "connectorRuntimeSettings value"));
            }
            return this;
        }

        @JsonProperty(value="credentials")
        public final Builder credentials(Credentials credentials) {
            this.credentials = Objects.requireNonNull(credentials, "credentials");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableValidateCredentialsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValidateCredentialsRequest(this.connectorRuntimeSettings == null ? null : ImmutableValidateCredentialsRequest.createUnmodifiableMap(false, false, this.connectorRuntimeSettings), this.credentials);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("credentials");
            }
            return "Cannot build ValidateCredentialsRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ValidateCredentialsRequest", generator="Immutables")
    static final class Json
    implements ValidateCredentialsRequest {
        @Nullable
        Map<String, String> connectorRuntimeSettings = null;
        @Nullable
        Credentials credentials;

        Json() {
        }

        @JsonProperty(value="connectorRuntimeSettings")
        public void setConnectorRuntimeSettings(@Nullable Map<String, String> connectorRuntimeSettings) {
            this.connectorRuntimeSettings = connectorRuntimeSettings;
        }

        @JsonProperty(value="credentials")
        public void setCredentials(Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public Map<String, String> connectorRuntimeSettings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Credentials credentials() {
            throw new UnsupportedOperationException();
        }
    }
}

