/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.credentials;

import com.amazonaws.appflow.custom.connector.model.credentials.AuthenticationType;
import com.amazonaws.appflow.custom.connector.model.credentials.Credentials;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Credentials", generator="Immutables")
@Immutable
public final class ImmutableCredentials
implements Credentials {
    @Nullable
    private final String secretArn;
    @Nullable
    private final AuthenticationType authenticationType;

    private ImmutableCredentials(@Nullable String secretArn, @Nullable AuthenticationType authenticationType) {
        this.secretArn = secretArn;
        this.authenticationType = authenticationType;
    }

    @Override
    @JsonProperty(value="secretArn")
    @Nullable
    public String secretArn() {
        return this.secretArn;
    }

    @Override
    @JsonProperty(value="authenticationType")
    @Nullable
    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public final ImmutableCredentials withSecretArn(@Nullable String value) {
        if (Objects.equals(this.secretArn, value)) {
            return this;
        }
        return new ImmutableCredentials(value, this.authenticationType);
    }

    public final ImmutableCredentials withAuthenticationType(@Nullable AuthenticationType value) {
        if (this.authenticationType == value) {
            return this;
        }
        return new ImmutableCredentials(this.secretArn, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCredentials && this.equalTo(0, (ImmutableCredentials)another);
    }

    private boolean equalTo(int synthetic, ImmutableCredentials another) {
        return Objects.equals(this.secretArn, another.secretArn) && Objects.equals((Object)this.authenticationType, (Object)another.authenticationType);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.secretArn);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.authenticationType);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Credentials").omitNullValues().add("secretArn", this.secretArn).add("authenticationType", (Object)this.authenticationType).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCredentials fromJson(Json json) {
        Builder builder = ImmutableCredentials.builder();
        if (json.secretArn != null) {
            builder.secretArn(json.secretArn);
        }
        if (json.authenticationType != null) {
            builder.authenticationType(json.authenticationType);
        }
        return builder.build();
    }

    public static ImmutableCredentials copyOf(Credentials instance) {
        if (instance instanceof ImmutableCredentials) {
            return (ImmutableCredentials)instance;
        }
        return ImmutableCredentials.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Credentials", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String secretArn;
        @Nullable
        private AuthenticationType authenticationType;

        private Builder() {
        }

        public final Builder from(Credentials instance) {
            AuthenticationType authenticationTypeValue;
            Objects.requireNonNull(instance, "instance");
            String secretArnValue = instance.secretArn();
            if (secretArnValue != null) {
                this.secretArn(secretArnValue);
            }
            if ((authenticationTypeValue = instance.authenticationType()) != null) {
                this.authenticationType(authenticationTypeValue);
            }
            return this;
        }

        @JsonProperty(value="secretArn")
        public final Builder secretArn(@Nullable String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        @JsonProperty(value="authenticationType")
        public final Builder authenticationType(@Nullable AuthenticationType authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public ImmutableCredentials build() {
            return new ImmutableCredentials(this.secretArn, this.authenticationType);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Credentials", generator="Immutables")
    static final class Json
    implements Credentials {
        @Nullable
        String secretArn;
        @Nullable
        AuthenticationType authenticationType;

        Json() {
        }

        @JsonProperty(value="secretArn")
        public void setSecretArn(@Nullable String secretArn) {
            this.secretArn = secretArn;
        }

        @JsonProperty(value="authenticationType")
        public void setAuthenticationType(@Nullable AuthenticationType authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public String secretArn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AuthenticationType authenticationType() {
            throw new UnsupportedOperationException();
        }
    }
}

