/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.integ.tests;

import com.amazonaws.appflow.custom.connector.integ.data.CustomConnectorConfiguration;
import com.amazonaws.appflow.custom.connector.integ.data.CustomConnectorProfileConfiguration;
import com.amazonaws.appflow.custom.connector.integ.data.DescribeConnectorEntityTestConfiguration;
import com.amazonaws.appflow.custom.connector.integ.data.ListConnectorEntitiesTestConfiguration;
import com.amazonaws.appflow.custom.connector.integ.data.OnDemandFromS3TestConfiguration;
import com.amazonaws.appflow.custom.connector.integ.data.OnDemandToS3TestConfiguration;
import com.amazonaws.appflow.custom.connector.integ.data.TestConfiguration;
import com.amazonaws.appflow.custom.connector.integ.providers.DataProvider;
import com.amazonaws.appflow.custom.connector.integ.providers.RequestProvider;
import com.amazonaws.appflow.custom.connector.integ.providers.ResourceInfoProvider;
import com.amazonaws.appflow.custom.connector.integ.providers.ServiceProvider;
import com.amazonaws.appflow.custom.connector.integ.tests.TestConfigurationDataProvider;
import com.amazonaws.appflow.custom.connector.integ.util.ConfigurationUtil;
import com.amazonaws.appflow.custom.connector.integ.util.ImmutablePollingConfiguration;
import com.amazonaws.appflow.custom.connector.integ.util.S3Helper;
import com.amazonaws.services.appflow.AmazonAppflow;
import com.amazonaws.services.appflow.model.ConnectorEntity;
import com.amazonaws.services.appflow.model.ConnectorEntityField;
import com.amazonaws.services.appflow.model.CreateFlowRequest;
import com.amazonaws.services.appflow.model.DescribeConnectorEntityResult;
import com.amazonaws.services.appflow.model.DescribeConnectorResult;
import com.amazonaws.services.appflow.model.ExecutionRecord;
import com.amazonaws.services.appflow.model.ExecutionStatus;
import com.amazonaws.services.appflow.model.ListConnectorEntitiesResult;
import com.amazonaws.services.appflow.model.StartFlowRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BasicCustomConnectorTestCases {
    private static final Integer MAX_POLLING_TIME = 180;
    protected ResourceInfoProvider resourceInfoProvider;
    protected RequestProvider requestProvider;
    protected AmazonAppflow appflow;
    protected S3Helper s3Helper;
    protected TestConfiguration configuration;

    @BeforeClass
    public void setUp(ITestContext iTestContext) {
        this.configuration = ConfigurationUtil.getTestConfiguration(iTestContext);
        this.resourceInfoProvider = new ResourceInfoProvider(this.configuration);
        this.appflow = ServiceProvider.getAppflow();
        this.requestProvider = new RequestProvider(this.resourceInfoProvider, this.configuration.testBucketConfiguration());
        this.s3Helper = new S3Helper(this.configuration.testBucketConfiguration());
    }

    @Test(dataProvider="CreateConnectorConfigs", dataProviderClass=TestConfigurationDataProvider.class)
    public void testRegisterConnector(CustomConnectorConfiguration configuration) {
        this.appflow.registerConnector(this.requestProvider.getRegisterConnectorRequest(configuration));
        DescribeConnectorResult actualResult = this.appflow.describeConnector(this.requestProvider.getDescribeConnectorRequest(configuration));
        if (configuration.validationFileName().isPresent()) {
            DescribeConnectorResult expectedResult = ConfigurationUtil.getDescribeConnectorFile(configuration.validationFileName().get());
            expectedResult.getConnectorConfiguration().setConnectorLabel(actualResult.getConnectorConfiguration().getConnectorLabel());
            expectedResult.getConnectorConfiguration().setRegisteredAt(actualResult.getConnectorConfiguration().getRegisteredAt());
            expectedResult.getConnectorConfiguration().setRegisteredBy(actualResult.getConnectorConfiguration().getRegisteredBy());
            Assert.assertEquals(expectedResult, actualResult);
        }
        this.resourceInfoProvider.addToCreatedConnectors(configuration.name());
    }

    @Test(dataProvider="CreateConnectorProfileConfigs", dataProviderClass=TestConfigurationDataProvider.class, dependsOnMethods={"testRegisterConnector"}, alwaysRun=true)
    public void testCreateConnectorProfile(CustomConnectorProfileConfiguration configuration) {
        this.appflow.createConnectorProfile(this.requestProvider.getCreateConnectorProfileRequest(configuration));
        this.resourceInfoProvider.addToCreatedProfiles(configuration.name());
    }

    @Test(dataProvider="ListEntitiesConfigs", dataProviderClass=TestConfigurationDataProvider.class, groups={"tests"}, dependsOnMethods={"testCreateConnectorProfile"}, alwaysRun=true)
    public void testListConnectorEntities(ListConnectorEntitiesTestConfiguration configuration) {
        ListConnectorEntitiesResult actualResult = this.appflow.listConnectorEntities(this.requestProvider.getListConnectorEntitiesRequest(configuration));
        if (configuration.validationFileName().isPresent()) {
            ListConnectorEntitiesResult expectedResult = ConfigurationUtil.getListEntitiesFile(configuration.validationFileName().get());
            for (Map.Entry<String, List<ConnectorEntity>> expectedEntities : expectedResult.getConnectorEntityMap().entrySet()) {
                for (ConnectorEntity expectedEntity : expectedEntities.getValue()) {
                    Optional<ConnectorEntity> actual = actualResult.getConnectorEntityMap().get(expectedEntities.getKey()).stream().filter(ent -> ent.getName().equals(expectedEntity.getName())).findFirst();
                    Assert.assertTrue(actual.isPresent());
                    Assert.assertEquals(actual.get(), expectedEntity);
                }
            }
        }
    }

    @Test(dataProvider="DescribeEntitiesConfigs", dataProviderClass=TestConfigurationDataProvider.class, groups={"tests"}, dependsOnMethods={"testCreateConnectorProfile"}, alwaysRun=true)
    public void testDescribeConnectorEntity(DescribeConnectorEntityTestConfiguration configuration) {
        DescribeConnectorEntityResult result = this.appflow.describeConnectorEntity(this.requestProvider.getDescribeConnectorEntityRequest(configuration));
        if (configuration.validationFileName().isPresent()) {
            DescribeConnectorEntityResult actual = ConfigurationUtil.getDescribeEntityFile(configuration.validationFileName().get());
            for (ConnectorEntityField expectedField : actual.getConnectorEntityFields()) {
                Optional<ConnectorEntityField> actualField = result.getConnectorEntityFields().stream().filter(connectorEntityField -> connectorEntityField.getIdentifier().equals(expectedField.getIdentifier())).findFirst();
                Assert.assertTrue(actualField.isPresent());
                Assert.assertEquals(actualField.get(), expectedField);
            }
        }
    }

    @Test(dataProvider="SourceFlowConfigs", dataProviderClass=TestConfigurationDataProvider.class, groups={"tests"}, dependsOnMethods={"testCreateConnectorProfile"}, alwaysRun=true)
    public void testSourceFlowExecutionOnDemand(OnDemandToS3TestConfiguration configuration) {
        String flowName = this.resourceInfoProvider.generateFlowName(configuration.flowName());
        CreateFlowRequest createFlowRequest = this.requestProvider.getSourceCreateFlowRequest(configuration);
        this.appflow.createFlow(createFlowRequest);
        String executionId = this.appflow.startFlow(new StartFlowRequest().withFlowName(flowName)).getExecutionId();
        Optional<ExecutionRecord> executionRecord = ServiceProvider.getFlowPoller().pollForExecutionRecordsResponse(ImmutablePollingConfiguration.builder().executionId(executionId).maxPollTimeS(configuration.flowTimeout().orElse(MAX_POLLING_TIME)).timeBetweenPollsS(configuration.flowTimeout().orElse(MAX_POLLING_TIME) / 5).flowName(flowName).build());
        Assert.assertTrue(executionRecord.isPresent());
        Assert.assertEquals(executionRecord.get().getExecutionStatus(), ExecutionStatus.Successful.toString());
        configuration.outputSize().ifPresent(size -> Assert.assertEquals((Object)((ExecutionRecord)executionRecord.get()).getExecutionResult().getBytesWritten(), size));
    }

    @Test(dataProvider="DestinationFlowConfigs", dataProviderClass=TestConfigurationDataProvider.class, groups={"tests"}, dependsOnMethods={"testCreateConnectorProfile"}, alwaysRun=true)
    public void testDestinationFlowExecutionOnDemand(OnDemandFromS3TestConfiguration configuration) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String file;
        String flowName = this.resourceInfoProvider.generateFlowName(configuration.flowName());
        if (configuration.sourceDataFile().isPresent()) {
            file = new String(Files.readAllBytes(Paths.get(configuration.sourceDataFile().get(), new String[0])), StandardCharsets.UTF_8);
        } else if (configuration.dataGeneratorClassName().isPresent()) {
            Class<?> clazz = Class.forName(configuration.dataGeneratorClassName().get());
            DataProvider provider = (DataProvider)clazz.newInstance();
            file = provider.GenerateData();
        } else {
            throw new RuntimeException("Either Source data file or data generator class is needed to run test.");
        }
        String[] lines = file.split("\n");
        List<String> fields = Arrays.asList(lines[0].split(","));
        this.s3Helper.uploadFile(file, configuration.flowName());
        CreateFlowRequest createFlowRequest = this.requestProvider.getDestinationCreateFlowRequest(configuration, fields);
        this.appflow.createFlow(createFlowRequest);
        String executionId = this.appflow.startFlow(new StartFlowRequest().withFlowName(flowName)).getExecutionId();
        Optional<ExecutionRecord> executionRecord = ServiceProvider.getFlowPoller().pollForExecutionRecordsResponse(ImmutablePollingConfiguration.builder().executionId(executionId).maxPollTimeS(configuration.flowTimeout().orElse(MAX_POLLING_TIME)).timeBetweenPollsS(configuration.flowTimeout().orElse(MAX_POLLING_TIME) / 5).flowName(flowName).build());
        Assert.assertTrue(executionRecord.isPresent());
        Assert.assertEquals(executionRecord.get().getExecutionStatus(), ExecutionStatus.Successful.toString());
        Assert.assertEquals((long)executionRecord.get().getExecutionResult().getRecordsProcessed(), (long)(lines.length - 1));
    }
}

