/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.integ.providers;

import com.amazonaws.appflow.custom.connector.integ.data.TestConfiguration;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.testng.SkipException;

public class ResourceInfoProvider {
    private final HashMap<String, String> versions;
    private final HashMap<String, String> names;
    private final Set<String> createdProfiles;
    private final Set<String> createdConnectors;
    public static final String INTEG_CONNECTOR = "Integ_Connector_";
    public static final String INTEG_PROFILE = "Integ_Profile_";
    public static final String INTEG_FLOW = "Integ_Flow_";
    private final String defaultConnectorName;
    private final String prefix;
    private final String defaultProfileName;
    private final long testStartTime;

    public ResourceInfoProvider(TestConfiguration testConfiguration) {
        this.defaultConnectorName = testConfiguration.customConnectorConfigurations().get(0).name();
        this.defaultProfileName = testConfiguration.customConnectorProfileConfigurations().get(0).name();
        this.prefix = testConfiguration.resourcePrefix().orElse("");
        this.versions = new HashMap();
        testConfiguration.customConnectorProfileConfigurations().forEach(configuration -> this.versions.put(configuration.name(), configuration.defaultApiVersion().orElse("1")));
        this.names = new HashMap();
        testConfiguration.customConnectorProfileConfigurations().forEach(configuration -> this.names.put(configuration.name(), configuration.connectorName().orElse(testConfiguration.customConnectorConfigurations().get(0).name())));
        this.testStartTime = Instant.now().getEpochSecond();
        this.createdProfiles = new HashSet<String>();
        this.createdConnectors = new HashSet<String>();
    }

    public String getApiForProfileName(Optional<String> profileName, Optional<String> apiVersion) {
        String profileName2 = profileName.orElse(this.defaultProfileName);
        return apiVersion.orElse(this.versions.get(profileName2));
    }

    public String getVersionForProfile(String profileName) {
        return this.versions.get(profileName);
    }

    public String getConnectorForProfile(String profileName) {
        return this.names.get(profileName);
    }

    public String getConnectorForProfileName(Optional<String> profileName) {
        String profileName2 = profileName.orElse(this.defaultProfileName);
        return this.getConnectorName(Optional.ofNullable(this.names.get(profileName2)));
    }

    public String getConnectorName(Optional<String> connectorName) {
        return this.getConnectorNameIfCreated(connectorName.orElse(this.defaultConnectorName));
    }

    public String getProfileName(Optional<String> profileName) {
        return this.getProfileNameIfCreated(profileName.orElse(this.defaultProfileName));
    }

    public String generateFlowName(String configName) {
        return this.generateResourceName(configName, this.prefix + INTEG_FLOW);
    }

    public String generateProfileName(String configName) {
        return this.generateResourceName(configName, this.prefix + INTEG_PROFILE);
    }

    public String generateConnectorName(String configName) {
        return this.generateResourceName(configName, this.prefix + INTEG_CONNECTOR);
    }

    public String generateResourceName(String configName, String prefix) {
        return prefix + configName + this.testStartTime;
    }

    public String getConnectorNameIfCreated(String configName) {
        String connectorName = this.generateConnectorName(configName);
        if (!this.createdConnectors.contains(connectorName)) {
            throw new SkipException(String.format("%s hasn't been created", connectorName));
        }
        return connectorName;
    }

    public String getProfileNameIfCreated(String configName) {
        String profileName = this.generateProfileName(configName);
        if (!this.createdProfiles.contains(configName)) {
            throw new SkipException(String.format("%s hasn't been created", profileName));
        }
        return profileName;
    }

    public void addToCreatedProfiles(String profileName) {
        this.createdProfiles.add(profileName);
    }

    public void addToCreatedConnectors(String profileName) {
        this.createdConnectors.add(this.generateConnectorName(profileName));
    }
}

