/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.example.validation;

import com.amazonaws.appflow.custom.connector.example.configuration.SalesforceConnectorConfiguration;
import com.amazonaws.appflow.custom.connector.model.ConnectorContext;
import com.amazonaws.appflow.custom.connector.model.ErrorCode;
import com.amazonaws.appflow.custom.connector.model.ErrorDetails;
import com.amazonaws.appflow.custom.connector.model.ImmutableErrorDetails;
import com.amazonaws.appflow.custom.connector.model.credentials.Credentials;
import com.amazonaws.appflow.custom.connector.model.metadata.DescribeEntityRequest;
import com.amazonaws.appflow.custom.connector.model.metadata.ListEntitiesRequest;
import com.amazonaws.appflow.custom.connector.model.query.QueryDataRequest;
import com.amazonaws.appflow.custom.connector.model.retreive.RetrieveDataRequest;
import com.amazonaws.appflow.custom.connector.model.write.WriteDataRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public final class RequestValidator {
    private RequestValidator() {
    }

    public static ErrorDetails validateListEntitiesRequest(ListEntitiesRequest request) {
        List<String> errors = RequestValidator.validateConnectorContext(request.connectorContext());
        if (CollectionUtils.isEmpty(errors)) {
            return null;
        }
        return ImmutableErrorDetails.builder().errorCode(ErrorCode.InvalidArgument).errorMessage(String.join((CharSequence)",", errors)).build();
    }

    public static ErrorDetails validateDescribeEntityRequest(DescribeEntityRequest request) {
        List<String> errors = RequestValidator.validateConnectorContext(request.connectorContext());
        if (CollectionUtils.isEmpty(errors)) {
            return null;
        }
        return ImmutableErrorDetails.builder().errorCode(ErrorCode.InvalidArgument).errorMessage(String.join((CharSequence)",", errors)).build();
    }

    public static ErrorDetails validateRetrieveDataRequest(RetrieveDataRequest request) {
        List<String> errors = RequestValidator.validateConnectorContext(request.connectorContext());
        if (CollectionUtils.isEmpty(errors)) {
            return null;
        }
        return ImmutableErrorDetails.builder().errorCode(ErrorCode.InvalidArgument).errorMessage(String.join((CharSequence)",", errors)).build();
    }

    public static ErrorDetails validateWriteDataRequest(WriteDataRequest request) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!SalesforceConnectorConfiguration.supportedWriteOperations().contains((Object)request.operation())) {
            errors.add(String.format("Operation %s is not supported by Salesforce", new Object[]{request.operation()}));
        }
        errors.addAll(RequestValidator.validateConnectorContext(request.connectorContext()));
        if (CollectionUtils.isEmpty(errors)) {
            return null;
        }
        return ImmutableErrorDetails.builder().errorCode(ErrorCode.InvalidArgument).errorMessage(String.join((CharSequence)",", errors)).build();
    }

    public static ErrorDetails validateQueryDataRequest(QueryDataRequest request) {
        List<String> errors = RequestValidator.validateConnectorContext(request.connectorContext());
        if (CollectionUtils.isEmpty(errors)) {
            return null;
        }
        return ImmutableErrorDetails.builder().errorCode(ErrorCode.InvalidArgument).errorMessage(String.join((CharSequence)",", errors)).build();
    }

    private static List<String> validateConnectorContext(ConnectorContext connectorContext) {
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(RequestValidator.validateCredentialsInput(connectorContext.credentials()));
        errors.addAll(RequestValidator.validateConnectorRuntimeSettingsInput(connectorContext.connectorRuntimeSettings()));
        return errors;
    }

    private static List<String> validateCredentialsInput(Credentials credentials) {
        ArrayList<String> errors = new ArrayList<String>();
        if (Objects.isNull(credentials.secretArn())) {
            errors.add("Secret Arn for credentials should be provided as part of request in ConnectorContext");
        }
        return errors;
    }

    private static List<String> validateConnectorRuntimeSettingsInput(Map<String, String> connectorRuntimeSettingMap) {
        ArrayList<String> errors = new ArrayList<String>();
        if (Objects.isNull(connectorRuntimeSettingMap)) {
            errors.add("Connector Context cannot be null for the Salesforce connector");
            return errors;
        }
        if (!connectorRuntimeSettingMap.containsKey("instanceUrl")) {
            errors.add("InstanceUrl should be provided as connector setting for the Salesforce connector");
        }
        return errors;
    }
}

