/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.example.query;

import com.amazonaws.appflow.custom.connector.example.query.QueryObject;
import com.amazonaws.appflow.custom.connector.example.query.SalesForceQueryFilterExpressionVisitor;
import com.amazonaws.appflow.custom.connector.model.metadata.EntityDefinition;
import com.amazonaws.appflow.custom.connector.model.metadata.FieldDataType;
import com.amazonaws.appflow.custom.connector.queryfilter.CustomConnectorParseTreeBuilder;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;

public final class SalesforceQueryBuilder {
    private static final String CONDITION_FORMAT = "%s %s %s";
    private static final String WHERE_AND = " and ";
    private static final String CLAUSE_STRING_FORMAT = "%s %s";
    private static final String WHERE_CLAUSE = "where";
    private static final String FROM_CLAUSE = "from";
    private static final String SELECT_CLAUSE = "select";

    private SalesforceQueryBuilder() {
    }

    public static String buildQuery(QueryObject queryObject) {
        if (CollectionUtils.isEmpty(queryObject.selectedFieldNames())) {
            throw new IllegalArgumentException("No fields where selected for Salesforce Query");
        }
        ArrayList<String> clauses = new ArrayList<String>();
        List<String> conditions = new ArrayList<String>();
        String selectFields = String.join((CharSequence)", ", queryObject.selectedFieldNames());
        clauses.add(String.format(CLAUSE_STRING_FORMAT, SELECT_CLAUSE, selectFields));
        clauses.add(String.format(CLAUSE_STRING_FORMAT, FROM_CLAUSE, queryObject.sObject()));
        if (Strings.isNotBlank(queryObject.filterExpression())) {
            String whereClause = SalesforceQueryBuilder.translateFilterExpression(queryObject.filterExpression(), queryObject.entityDefinition());
            if (StringUtils.isNotBlank(whereClause)) {
                clauses.add(String.format(CLAUSE_STRING_FORMAT, WHERE_CLAUSE, whereClause));
            }
        } else {
            if (StringUtils.isNotBlank(queryObject.idFieldName()) && CollectionUtils.isNotEmpty(queryObject.fields()) && StringUtils.isNotBlank(queryObject.dataType())) {
                conditions = SalesforceQueryBuilder.addOrConditions("=", conditions, queryObject.idFieldName(), queryObject.fields(), queryObject.dataType());
            }
            if (CollectionUtils.isNotEmpty(conditions)) {
                String whereClause = String.join((CharSequence)WHERE_AND, conditions);
                clauses.add(String.format(CLAUSE_STRING_FORMAT, WHERE_CLAUSE, whereClause));
            }
        }
        return String.join((CharSequence)" ", clauses);
    }

    private static List<String> addOrConditions(String operator, List<String> conditions, String variable, List<String> values, String type) {
        ArrayList<String> orConditions = new ArrayList<String>();
        for (String value : values) {
            SalesforceQueryBuilder.addCondition(operator, orConditions, variable, value, type);
        }
        String condition = "(" + String.join((CharSequence)" or ", orConditions) + ")";
        conditions.add(condition);
        return conditions;
    }

    private static List<String> addCondition(String operator, List<String> conditions, String fieldName, String value, String type) {
        String formattedValue = SalesforceQueryBuilder.formatType(type, value);
        conditions.add(String.format(CONDITION_FORMAT, fieldName, operator, formattedValue));
        return conditions;
    }

    private static String formatType(String type, String value) {
        String formattedValue = value;
        boolean customerQuoted = false;
        if (formattedValue.startsWith("'") || formattedValue.startsWith("\"")) {
            formattedValue = formattedValue.substring(1);
            customerQuoted = true;
        }
        if (formattedValue.endsWith("'") || formattedValue.endsWith("\"")) {
            formattedValue = formattedValue.substring(0, formattedValue.length() - 1);
            customerQuoted = true;
        }
        formattedValue = formattedValue.replace("'", "\\'");
        if (FieldDataType.Struct.name().equals(type) || customerQuoted) {
            return SalesforceQueryBuilder.addSingleQuotes(formattedValue);
        }
        return formattedValue;
    }

    private static String addSingleQuotes(String string) {
        return '\'' + string + '\'';
    }

    private static String translateFilterExpression(String filterExpression, EntityDefinition entityDefinition) {
        if (StringUtils.isNotBlank(filterExpression)) {
            ParseTree parseTree = CustomConnectorParseTreeBuilder.parse(filterExpression);
            SalesForceQueryFilterExpressionVisitor salesForceQueryFilterExpressionVisitor = new SalesForceQueryFilterExpressionVisitor(entityDefinition);
            salesForceQueryFilterExpressionVisitor.visit(parseTree);
            return salesForceQueryFilterExpressionVisitor.getResult();
        }
        return "";
    }
}

