/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.example.query;

import com.amazonaws.appflow.custom.connector.model.metadata.EntityDefinition;
import com.amazonaws.appflow.custom.connector.model.metadata.FieldDefinition;
import com.amazonaws.appflow.custom.connector.queryfilter.antlr.CustomConnectorQueryFilterParser;
import com.amazonaws.appflow.custom.connector.queryfilter.antlr.CustomConnectorQueryFilterParserBaseVisitor;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SalesForceQueryFilterExpressionVisitor
extends CustomConnectorQueryFilterParserBaseVisitor<StringBuilder> {
    private final StringBuilder queryBuilder = new StringBuilder();
    private EntityDefinition entityDefinition;
    private static final String SPACE = " ";
    public static final String DATE_TIME = "DateTime";
    public static final String DATE = "Date";
    private static final List<String> DATE_TYPES = Arrays.asList("Date", "DateTime");
    private static final List<String> STRING_TYPES = Arrays.asList("String", "id", "textarea");
    private static final List<String> NON_STRING_TYPES = Arrays.asList("Boolean", "double", "Integer", "Float", "Double", "Short", "Long", "Currency");
    private static final Map<String, DateTimeFormatter> FORMAT_TYPE_MAP = new HashMap<String, DateTimeFormatter>(){
        {
            this.put(SalesForceQueryFilterExpressionVisitor.DATE, DateTimeFormatter.ofPattern("uuuu-MM-dd").withZone(ZoneId.of("UTC")));
            this.put(SalesForceQueryFilterExpressionVisitor.DATE_TIME, DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSZ").withZone(ZoneId.of("UTC")));
        }
    };
    private static final String CONTAINS = "CONTAINS";
    private static final String CONDITION_FORMAT = "%s %s %s";
    private static final String LIKE = "LIKE";
    private static final String LOGICAL_AND = " and ";
    private static final String IN = " IN ";
    private static final String LEFT_PARENTHESIS = "(";
    private static final String RIGHT_PARENTHESIS = ")";
    private static final String COMPARISON_LESSER = "<";
    private static final String COMPARISON_GREATER = ">";
    private static final ValueFormatter FORMATTER = (value, type, operator) -> {
        String formattedVal = value;
        boolean hasCustomQuotes = ValueFormatter.HAS_CUSTOM_QUOTES.test(value);
        if (hasCustomQuotes) {
            formattedVal = ValueFormatter.STRIP_QUOTES.apply(formattedVal);
        }
        formattedVal = ValueFormatter.REPLACE_SINGLE_QUOTES.apply(formattedVal);
        if (DATE_TYPES.contains(type)) {
            return ValueFormatter.FORMAT_DATE_TYPE.apply(formattedVal, type);
        }
        if (STRING_TYPES.contains(type) || hasCustomQuotes && !NON_STRING_TYPES.contains(type)) {
            return ValueFormatter.ADD_WILD_CARDS.andThen(ValueFormatter.ADD_SINGLE_QUOTES).apply(formattedVal, operator);
        }
        return formattedVal;
    };

    public SalesForceQueryFilterExpressionVisitor(EntityDefinition entityDefinition) {
        Objects.requireNonNull(entityDefinition, "entityDefinition can't be null as it is required for building filter query");
        this.entityDefinition = entityDefinition;
    }

    @Override
    public StringBuilder visitBetweenExpression(CustomConnectorQueryFilterParser.BetweenExpressionContext ctx) {
        if (ctx.getChildCount() == 5) {
            String identifier = ctx.getChild(0).getText();
            String lowerBound = ctx.getChild(2).getText();
            String upperBound = ctx.getChild(4).getText();
            String dataType = this.getFieldDatatype(ctx.getChild(0).getText()).dataType().name();
            return this.queryBuilder.append(String.format(CONDITION_FORMAT, identifier, COMPARISON_GREATER, FORMATTER.formatValue(lowerBound, dataType, COMPARISON_GREATER))).append(LOGICAL_AND).append(String.format(CONDITION_FORMAT, identifier, COMPARISON_LESSER, FORMATTER.formatValue(upperBound, dataType, COMPARISON_LESSER)));
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitInExpression(CustomConnectorQueryFilterParser.InExpressionContext ctx) {
        if (ctx.value().size() > 0) {
            String identifier = ctx.getChild(0).getText();
            String dataType = this.getFieldDatatype(identifier).dataType().name();
            this.queryBuilder.append(identifier).append(IN).append(LEFT_PARENTHESIS);
            List<CustomConnectorQueryFilterParser.ValueContext> inClauseValues = ctx.value();
            String values = inClauseValues.stream().map(valueContext -> FORMATTER.formatValue(valueContext.getText(), dataType, null)).collect(Collectors.joining(","));
            this.queryBuilder.append(values).append(RIGHT_PARENTHESIS);
            return this.queryBuilder;
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitGreaterThanEqualToComparatorExpression(CustomConnectorQueryFilterParser.GreaterThanEqualToComparatorExpressionContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.queryBuilder.append(ctx.getText()).append(SPACE);
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitGtComparator(CustomConnectorQueryFilterParser.GtComparatorContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.queryBuilder.append(ctx.getText()).append(SPACE);
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitGeComparator(CustomConnectorQueryFilterParser.GeComparatorContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.queryBuilder.append(ctx.getText()).append(SPACE);
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitLtComparator(CustomConnectorQueryFilterParser.LtComparatorContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.queryBuilder.append(ctx.getText()).append(SPACE);
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitLeComparator(CustomConnectorQueryFilterParser.LeComparatorContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.queryBuilder.append(ctx.getText()).append(SPACE);
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitEqComparator(CustomConnectorQueryFilterParser.EqComparatorContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.queryBuilder.append(ctx.getText()).append(SPACE);
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitNeComparator(CustomConnectorQueryFilterParser.NeComparatorContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.queryBuilder.append(ctx.getText()).append(SPACE);
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitLikeComparator(CustomConnectorQueryFilterParser.LikeComparatorContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.queryBuilder.append(LIKE).append(SPACE);
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitBetweenComparator(CustomConnectorQueryFilterParser.BetweenComparatorContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.queryBuilder.append(ctx.getText()).append(SPACE);
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitAndBinary(CustomConnectorQueryFilterParser.AndBinaryContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.queryBuilder.append(ctx.getText()).append(SPACE);
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitOrBinary(CustomConnectorQueryFilterParser.OrBinaryContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.queryBuilder.append(ctx.getText()).append(SPACE);
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitIdentifier(CustomConnectorQueryFilterParser.IdentifierContext ctx) {
        if (ctx.getChildCount() == 1) {
            return this.queryBuilder.append(ctx.getText()).append(SPACE);
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitStringValueExpression(CustomConnectorQueryFilterParser.StringValueExpressionContext ctx) {
        if (ctx.getChildCount() == 1) {
            String dataType = this.getFieldDatatype(ctx.getParent().getChild(0).getText()).dataType().name();
            String value = FORMATTER.formatValue(ctx.getText(), dataType, ctx.getParent().getChild(1).getText());
            return this.queryBuilder.append(value).append(SPACE);
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitDecimalValueExpression(CustomConnectorQueryFilterParser.DecimalValueExpressionContext ctx) {
        if (ctx.getChildCount() == 1) {
            String dataType = this.getFieldDatatype(ctx.getParent().getChild(0).getText()).dataType().name();
            String value = FORMATTER.formatValue(ctx.getText(), dataType, ctx.getParent().getChild(1).getText());
            return this.queryBuilder.append(value).append(SPACE);
        }
        return (StringBuilder)this.visitChildren(ctx);
    }

    @Override
    public StringBuilder visitIsoDate(CustomConnectorQueryFilterParser.IsoDateContext ctx) {
        return this.queryBuilder.append(ctx.getText());
    }

    @Override
    public StringBuilder visitIsoDateTime(CustomConnectorQueryFilterParser.IsoDateTimeContext ctx) {
        return this.queryBuilder.append(OffsetDateTime.parse(ctx.getText()).toInstant().toString());
    }

    public String getResult() {
        return this.queryBuilder.toString();
    }

    private FieldDefinition getFieldDatatype(String fieldName) {
        return this.entityDefinition.fields().stream().filter(field -> StringUtils.equals(field.fieldName(), fieldName)).findFirst().orElseThrow(() -> new IllegalStateException("Filter attribute not found in entity definition"));
    }

    @FunctionalInterface
    static interface ValueFormatter {
        public static final Predicate<String> HAS_CUSTOM_QUOTES = val2 -> !(!val2.startsWith("'") && !val2.startsWith("\"") || !val2.endsWith("'") && !val2.endsWith("\""));
        public static final Function<String, String> STRIP_QUOTES = val2 -> val2.substring(1, val2.length() - 1);
        public static final Function<String, String> REPLACE_SINGLE_QUOTES = val2 -> val2.replace("'", "\\'");
        public static final BiFunction<String, String, String> ADD_WILD_CARDS = (val2, operator) -> SalesForceQueryFilterExpressionVisitor.CONTAINS.equalsIgnoreCase((String)operator) && !val2.contains("%") ? "%" + val2 + "%" : val2;
        public static final BiFunction<String, String, String> FORMAT_DATE_TYPE = (val2, type) -> {
            if (SalesForceQueryFilterExpressionVisitor.DATE.equals(type)) {
                return ((DateTimeFormatter)FORMAT_TYPE_MAP.get(type)).format(LocalDate.parse(val2));
            }
            return ((DateTimeFormatter)FORMAT_TYPE_MAP.get(type)).format(Instant.parse(val2));
        };
        public static final Function<String, String> ADD_SINGLE_QUOTES = val2 -> "'" + val2 + "'";

        public String formatValue(String var1, String var2, String var3);
    }
}

