/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.example.parser;

import com.amazonaws.appflow.custom.connector.example.parser.AbstractParser;
import com.amazonaws.appflow.custom.connector.model.write.ImmutableWriteRecordResult;
import com.amazonaws.appflow.custom.connector.model.write.WriteRecordResult;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class RecordResponseParser
extends AbstractParser {
    private static final Gson GSON = new Gson();

    private RecordResponseParser() {
    }

    public static List<String> parseQueryResponse(String jsonString) {
        JsonObject parentObject = GSON.fromJson(jsonString, JsonObject.class);
        ArrayList<String> records = new ArrayList<String>();
        if (Objects.nonNull(parentObject.get("records"))) {
            JsonArray jsonArray = parentObject.get("records").getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                records.add(jsonElement.toString());
            }
        }
        return records;
    }

    public static WriteRecordResult parseWriteResponse(String jsonString) {
        JsonObject parentObject = GSON.fromJson(jsonString, JsonObject.class);
        return ImmutableWriteRecordResult.builder().recordId(RecordResponseParser.getStringValue(parentObject, "id")).isSuccess(RecordResponseParser.getBooleanValue(parentObject, "success")).errorMessage(Objects.nonNull(parentObject.get("errors")) ? parentObject.get("errors").getAsJsonArray().toString() : null).build();
    }
}

