/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.example.handler;

import com.amazonaws.appflow.custom.connector.example.SalesforceResponse;
import com.amazonaws.appflow.custom.connector.example.handler.AbstractSalesforceHandler;
import com.amazonaws.appflow.custom.connector.example.parser.EntityParser;
import com.amazonaws.appflow.custom.connector.example.validation.RequestValidator;
import com.amazonaws.appflow.custom.connector.handlers.MetadataHandler;
import com.amazonaws.appflow.custom.connector.model.ErrorDetails;
import com.amazonaws.appflow.custom.connector.model.metadata.DescribeEntityRequest;
import com.amazonaws.appflow.custom.connector.model.metadata.DescribeEntityResponse;
import com.amazonaws.appflow.custom.connector.model.metadata.ImmutableDescribeEntityResponse;
import com.amazonaws.appflow.custom.connector.model.metadata.ImmutableListEntitiesResponse;
import com.amazonaws.appflow.custom.connector.model.metadata.ListEntitiesRequest;
import com.amazonaws.appflow.custom.connector.model.metadata.ListEntitiesResponse;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceMetadataHandler
extends AbstractSalesforceHandler
implements MetadataHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SalesforceMetadataHandler.class);
    private static final String SALESFORCE_SOBJECTS_URL_FORMAT = "%sservices/data/%s/sobjects";
    private static final String SALESFORCE_SOBJECT_URL_FORMAT = "%sservices/data/%s/sobjects/%s";
    private static final String SALESFORCE_SOBJECT_DESCRIBE_URL_FORMAT = "%sservices/data/%s/sobjects/%s/describe";

    @Override
    public ListEntitiesResponse listEntities(ListEntitiesRequest request) {
        ErrorDetails errorDetails = RequestValidator.validateListEntitiesRequest(request);
        if (Objects.nonNull(errorDetails)) {
            LOGGER.error("ListEntities request failed with errorDetails " + errorDetails);
            return ImmutableListEntitiesResponse.builder().isSuccess(false).errorDetails(errorDetails).build();
        }
        String requestUri = StringUtils.isEmpty(request.entitiesPath()) ? SalesforceMetadataHandler.buildSalesforceRequestURI(request.connectorContext(), SALESFORCE_SOBJECTS_URL_FORMAT, null) : SalesforceMetadataHandler.buildSalesforceRequestURI(request.connectorContext(), SALESFORCE_SOBJECT_URL_FORMAT, request.entitiesPath());
        SalesforceResponse salesforceResponse = this.getSalesforceClient(request.connectorContext()).restGet(requestUri);
        errorDetails = this.checkForErrorsInSalesforceResponse(salesforceResponse);
        if (Objects.nonNull(errorDetails)) {
            return ImmutableListEntitiesResponse.builder().isSuccess(false).errorDetails(errorDetails).build();
        }
        return ImmutableListEntitiesResponse.builder().isSuccess(true).entities(EntityParser.parseEntity(salesforceResponse.response())).build();
    }

    @Override
    public DescribeEntityResponse describeEntity(DescribeEntityRequest request) {
        ErrorDetails errorDetails = RequestValidator.validateDescribeEntityRequest(request);
        if (Objects.nonNull(errorDetails)) {
            LOGGER.error("DescribeEntity request failed with errorDetails " + errorDetails);
            return ImmutableDescribeEntityResponse.builder().isSuccess(false).errorDetails(errorDetails).build();
        }
        String requestUri = SalesforceMetadataHandler.buildSalesforceRequestURI(request.connectorContext(), SALESFORCE_SOBJECT_DESCRIBE_URL_FORMAT, request.entityIdentifier());
        SalesforceResponse salesforceResponse = this.getSalesforceClient(request.connectorContext()).restGet(requestUri);
        errorDetails = this.checkForErrorsInSalesforceResponse(salesforceResponse);
        if (Objects.nonNull(errorDetails)) {
            return ImmutableDescribeEntityResponse.builder().isSuccess(false).errorDetails(errorDetails).build();
        }
        return ImmutableDescribeEntityResponse.builder().isSuccess(true).entityDefinition(EntityParser.parseEntityDefinition(salesforceResponse.response())).build();
    }
}

