/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.example.configuration;

import com.amazonaws.appflow.custom.connector.example.configuration.SupportedSalesforceVersion;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.ConnectorModes;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.AuthenticationConfig;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.ImmutableAuthenticationConfig;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.ImmutableOAuth2Defaults;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.OAuth2Defaults;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.OAuth2GrantType;
import com.amazonaws.appflow.custom.connector.model.settings.ConnectorRuntimeSetting;
import com.amazonaws.appflow.custom.connector.model.settings.ConnectorRuntimeSettingDataType;
import com.amazonaws.appflow.custom.connector.model.settings.ConnectorRuntimeSettingScope;
import com.amazonaws.appflow.custom.connector.model.settings.ImmutableConnectorRuntimeSetting;
import com.amazonaws.appflow.custom.connector.model.write.WriteOperationType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SalesforceConnectorConfiguration {
    private SalesforceConnectorConfiguration() {
    }

    public static List<ConnectorRuntimeSetting> getConnectorRuntimeSettings() {
        ImmutableConnectorRuntimeSetting instanceUrl = ImmutableConnectorRuntimeSetting.builder().key("instanceUrl").dataType(ConnectorRuntimeSettingDataType.String).required(true).label("Salesforce Instance URL").description("URL of the instance where user wants to tun the operations.").scope(ConnectorRuntimeSettingScope.CONNECTOR_PROFILE).build();
        ImmutableConnectorRuntimeSetting apiVersion = ImmutableConnectorRuntimeSetting.builder().key("api_version").dataType(ConnectorRuntimeSettingDataType.String).required(true).label("Salesforce API version").description("Salesforce API version to use.").scope(ConnectorRuntimeSettingScope.CONNECTOR_PROFILE).build();
        return Arrays.asList(instanceUrl, apiVersion);
    }

    public static List<ConnectorModes> getConnectorModes() {
        return Arrays.asList(ConnectorModes.SOURCE, ConnectorModes.DESTINATION);
    }

    public static AuthenticationConfig getAuthenticationConfig() {
        return ImmutableAuthenticationConfig.builder().isOAuth2Supported(true).oAuth2Defaults(SalesforceConnectorConfiguration.getOAuth2Defaults()).build();
    }

    private static OAuth2Defaults getOAuth2Defaults() {
        return ImmutableOAuth2Defaults.builder().authURL(Collections.singletonList("https://login.salesforce.com/services/oauth2/authorize")).tokenURL(Collections.singletonList("https://login.salesforce.com/services/oauth2/token")).oAuthScopes(Arrays.asList("api", "refresh_token")).addOAuth2GrantTypesSupported(OAuth2GrantType.AUTHORIZATION_CODE).build();
    }

    public static List<String> getSupportedApiVersions() {
        return Collections.singletonList(SupportedSalesforceVersion.V51.getVersionNumber());
    }

    public static List<WriteOperationType> supportedWriteOperations() {
        return Arrays.asList(WriteOperationType.INSERT, WriteOperationType.UPDATE, WriteOperationType.UPSERT);
    }
}

