/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.example.client;

import com.amazonaws.appflow.custom.connector.example.ImmutableSalesforceResponse;
import com.amazonaws.appflow.custom.connector.example.SalesforceResponse;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class HttpClient {
    private static final int TEN_MINUTE_MS = 600000;
    private static final int SOCKET_TIMEOUT_MS = 600000;
    private static final int CONNECTION_TIMEOUT_MS = 30000;
    private static final int REQUEST_TIMEOUT_MS = 600000;
    private static final RequestConfig REQUEST_CONFIG = RequestConfig.custom().setConnectionRequestTimeout(600000).setConnectTimeout(30000).setSocketTimeout(600000).build();
    private final CloseableHttpClient httpClient;
    private final String accessToken;

    public HttpClient(String accessToken) {
        this.accessToken = accessToken;
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(REQUEST_CONFIG).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
    }

    public SalesforceResponse restGet(String requestUri) {
        URI uri = URI.create(requestUri);
        HttpGet getRequest = new HttpGet(uri);
        this.addAuthorizationHeader(getRequest);
        return this.execute(getRequest);
    }

    public SalesforceResponse restPost(String requestUri, String postData) {
        URI uri = URI.create(requestUri);
        HttpPost postRequest = new HttpPost(uri);
        this.addAuthorizationHeader(postRequest);
        this.addPostData(postRequest, postData);
        return this.execute(postRequest);
    }

    public SalesforceResponse restPatch(String requestUri, String patchData) {
        URI uri = URI.create(requestUri);
        HttpPatch patchRequest = new HttpPatch(uri);
        this.addAuthorizationHeader(patchRequest);
        this.addPatchData(patchRequest, patchData);
        return this.execute(patchRequest);
    }

    public final SalesforceResponse restPut(String requestUri, String putData) {
        URI uri = URI.create(requestUri);
        HttpPut putRequest = new HttpPut(uri);
        this.addAuthorizationHeader(putRequest);
        this.addPutData(putRequest, putData);
        return this.execute(putRequest);
    }

    public final SalesforceResponse restDelete(String requestUri) {
        URI uri = URI.create(requestUri);
        HttpDelete deleteRequest = new HttpDelete(uri);
        this.addAuthorizationHeader(deleteRequest);
        return this.execute(deleteRequest);
    }

    private SalesforceResponse execute(HttpUriRequest request) {
        try {
            CloseableHttpResponse httpResponse = this.httpClient.execute(request);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = Objects.isNull(httpResponse.getEntity()) ? null : EntityUtils.toString(httpResponse.getEntity(), StandardCharsets.UTF_8);
            String reason = httpResponse.getStatusLine().getReasonPhrase();
            return ImmutableSalesforceResponse.builder().statusCode(statusCode).response(response).errorReason(reason).build();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void addAuthorizationHeader(HttpRequestBase requestBase) {
        requestBase.addHeader("Authorization", "Bearer " + this.accessToken);
    }

    private void addPostData(HttpPost postRequest, String postData) {
        StringEntity params = new StringEntity(postData, ContentType.APPLICATION_JSON);
        postRequest.setEntity(params);
        postRequest.addHeader("Accept-Encoding", "gzip");
    }

    private void addPatchData(HttpPatch patchRequest, String patchData) {
        StringEntity params = new StringEntity(patchData, ContentType.APPLICATION_JSON);
        patchRequest.setEntity(params);
        patchRequest.addHeader("Accept-Encoding", "gzip");
    }

    private void addPutData(HttpPut putRequest, String putData) {
        StringEntity params = new StringEntity(putData, ContentType.create("text/csv", StandardCharsets.UTF_8));
        putRequest.setEntity(params);
        putRequest.addHeader("Content-Type", "text/csv");
    }
}

