/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.example;

import com.amazonaws.appflow.custom.connector.example.SalesforceResponse;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SalesforceResponse", generator="Immutables")
@Immutable
public final class ImmutableSalesforceResponse
implements SalesforceResponse {
    private final int statusCode;
    @Nullable
    private final String response;
    private final String errorReason;

    private ImmutableSalesforceResponse(int statusCode, @Nullable String response, String errorReason) {
        this.statusCode = statusCode;
        this.response = response;
        this.errorReason = errorReason;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @Nullable
    public String response() {
        return this.response;
    }

    @Override
    public String errorReason() {
        return this.errorReason;
    }

    public final ImmutableSalesforceResponse withStatusCode(int value) {
        if (this.statusCode == value) {
            return this;
        }
        return new ImmutableSalesforceResponse(value, this.response, this.errorReason);
    }

    public final ImmutableSalesforceResponse withResponse(@Nullable String value) {
        if (Objects.equals(this.response, value)) {
            return this;
        }
        return new ImmutableSalesforceResponse(this.statusCode, value, this.errorReason);
    }

    public final ImmutableSalesforceResponse withErrorReason(String value) {
        String newValue = Objects.requireNonNull(value, "errorReason");
        if (this.errorReason.equals(newValue)) {
            return this;
        }
        return new ImmutableSalesforceResponse(this.statusCode, this.response, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSalesforceResponse && this.equalTo(0, (ImmutableSalesforceResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableSalesforceResponse another) {
        return this.statusCode == another.statusCode && Objects.equals(this.response, another.response) && this.errorReason.equals(another.errorReason);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.statusCode;
        h2 += (h2 << 5) + Objects.hashCode(this.response);
        h2 += (h2 << 5) + this.errorReason.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SalesforceResponse").omitNullValues().add("statusCode", this.statusCode).add("response", this.response).add("errorReason", this.errorReason).toString();
    }

    public static ImmutableSalesforceResponse copyOf(SalesforceResponse instance) {
        if (instance instanceof ImmutableSalesforceResponse) {
            return (ImmutableSalesforceResponse)instance;
        }
        return ImmutableSalesforceResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SalesforceResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STATUS_CODE = 1L;
        private static final long INIT_BIT_ERROR_REASON = 2L;
        private long initBits = 3L;
        private int statusCode;
        @Nullable
        private String response;
        @Nullable
        private String errorReason;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SalesforceResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.statusCode(instance.statusCode());
            String responseValue = instance.response();
            if (responseValue != null) {
                this.response(responseValue);
            }
            this.errorReason(instance.errorReason());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder response(@Nullable String response) {
            this.response = response;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorReason(String errorReason) {
            this.errorReason = Objects.requireNonNull(errorReason, "errorReason");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSalesforceResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSalesforceResponse(this.statusCode, this.response, this.errorReason);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("statusCode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("errorReason");
            }
            return "Cannot build SalesforceResponse, some of required attributes are not set " + attributes;
        }
    }
}

