/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.appflow.custom.connector.lambda.handler.BaseLambdaConnectorHandler;
import com.amazonaws.appflow.custom.connector.tests.invokers.BaseConnectorTestInvoker;
import com.amazonaws.appflow.custom.connector.tests.model.TestConfig;
import com.amazonaws.appflow.custom.connector.util.CustomObjectMapper;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class RunTests {
    protected RunTests() {
    }

    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        Option optionHandlerName = Option.builder("h").argName("handlerName").hasArg().desc("Name of the connector handler to test").build();
        Option optionTestConfig = Option.builder("t").argName("testConfigFile").hasArg().desc("Location of the Test Configuration file").build();
        Options options = new Options();
        options.addOption(optionHandlerName);
        options.addOption(optionTestConfig);
        try {
            CommandLine commandLine = parser.parse(options, args);
            if (!commandLine.hasOption("h")) {
                System.out.println("Name of the class under test must be provided via the -h option.");
                System.exit(1);
            }
            if (!commandLine.hasOption("t")) {
                System.out.println("Location of the test configuration file must be provided via the -t option.");
                System.exit(1);
            }
            File configJson = new File(commandLine.getOptionValue("t"));
            ObjectMapper mapper = CustomObjectMapper.getObjectMapper();
            TestConfig testConfig = mapper.readValue(configJson, TestConfig.class);
            String className = commandLine.getOptionValue("h");
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object handler = constructor.newInstance(new Object[0]);
            BaseConnectorTestInvoker testInvoker = new BaseConnectorTestInvoker((BaseLambdaConnectorHandler)handler, testConfig);
            System.out.println("Starting connector verification tests for " + className);
            testInvoker.invokeConfigurationHandlerTests();
            testInvoker.invokeMetadataHandlerTests();
            testInvoker.invokeRecordHandlerTests();
            System.out.println("Tests completed successfully, see above logs for results");
            System.exit(0);
        }
        catch (ParseException e) {
            System.out.println("Parse Error");
            System.out.println(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            System.out.println("Could not resolve class definition");
            System.out.println(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            System.out.println("Could not locate no-args constructor in the specified handler");
            System.out.println(e.getMessage());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            System.out.println("Mapping exception");
            System.out.println(e.getMessage());
        }
        catch (JsonParseException e) {
            System.out.println("Cannot parse JSON");
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println("File was not found");
            System.out.println(e.getMessage());
        }
        System.exit(1);
    }
}

