/*
 * Decompiled with CFR 0.152.
 */
package org.testng.util;

import java.util.Map;
import org.testng.collections.Maps;

public final class Strings {
    private static final Map<String, String> ESCAPE_HTML_MAP = Maps.newLinkedHashMap();

    private Strings() {
    }

    public static String repeat(String text, int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(text);
        }
        return builder.toString();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static boolean isNotNullAndNotEmpty(String string) {
        return !Strings.isNullOrEmpty(string);
    }

    public static String getValueOrEmpty(String string) {
        return Strings.isNotNullAndNotEmpty(string) ? string : "";
    }

    public static String escapeHtml(String text) {
        String result = text;
        for (Map.Entry<String, String> entry : ESCAPE_HTML_MAP.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static String valueOf(Map<?, ?> m3) {
        StringBuilder result = new StringBuilder();
        for (Object o : m3.values()) {
            result.append(o).append(" ");
        }
        return result.toString();
    }

    public static String join(String delimiter, String[] parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length - 1; ++i) {
            sb.append(parts[i]).append(delimiter);
        }
        if (parts.length > 0) {
            sb.append(parts[parts.length - 1]);
        }
        return sb.toString();
    }

    static {
        ESCAPE_HTML_MAP.put("&", "&amp;");
        ESCAPE_HTML_MAP.put("<", "&lt;");
        ESCAPE_HTML_MAP.put(">", "&gt;");
    }
}

