/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.testng.IResultMap;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Objects;

public class ResultMap
implements IResultMap {
    private final Set<ITestResult> results = ConcurrentHashMap.newKeySet();

    @Override
    public void addResult(ITestResult result) {
        this.results.add(result);
    }

    @Override
    public Set<ITestResult> getResults(ITestNGMethod method) {
        return this.results.stream().filter(result -> result.getMethod().equals(method)).collect(Collectors.toSet());
    }

    @Override
    public void removeResult(ITestNGMethod m3) {
        Set<ITestResult> toRemove = this.getResults(m3);
        this.results.removeAll(toRemove);
    }

    @Override
    public void removeResult(ITestResult r) {
        this.results.remove(r);
    }

    @Override
    public Set<ITestResult> getAllResults() {
        return this.results;
    }

    @Override
    public int size() {
        return this.results.size();
    }

    @Override
    public Collection<ITestNGMethod> getAllMethods() {
        return this.results.stream().map(ITestResult::getMethod).collect(Collectors.toSet());
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("map", this.results).toString();
    }
}

