/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.licensemanager.model.transform.TokenDataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TokenData
implements Serializable,
Cloneable,
StructuredPojo {
    private String tokenId;
    private String tokenType;
    private String licenseArn;
    private String expirationTime;
    private List<String> tokenProperties;
    private List<String> roleArns;
    private String status;

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public TokenData withTokenId(String tokenId) {
        this.setTokenId(tokenId);
        return this;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public TokenData withTokenType(String tokenType) {
        this.setTokenType(tokenType);
        return this;
    }

    public void setLicenseArn(String licenseArn) {
        this.licenseArn = licenseArn;
    }

    public String getLicenseArn() {
        return this.licenseArn;
    }

    public TokenData withLicenseArn(String licenseArn) {
        this.setLicenseArn(licenseArn);
        return this;
    }

    public void setExpirationTime(String expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getExpirationTime() {
        return this.expirationTime;
    }

    public TokenData withExpirationTime(String expirationTime) {
        this.setExpirationTime(expirationTime);
        return this;
    }

    public List<String> getTokenProperties() {
        return this.tokenProperties;
    }

    public void setTokenProperties(Collection<String> tokenProperties) {
        if (tokenProperties == null) {
            this.tokenProperties = null;
            return;
        }
        this.tokenProperties = new ArrayList<String>(tokenProperties);
    }

    public TokenData withTokenProperties(String ... tokenProperties) {
        if (this.tokenProperties == null) {
            this.setTokenProperties(new ArrayList<String>(tokenProperties.length));
        }
        for (String ele : tokenProperties) {
            this.tokenProperties.add(ele);
        }
        return this;
    }

    public TokenData withTokenProperties(Collection<String> tokenProperties) {
        this.setTokenProperties(tokenProperties);
        return this;
    }

    public List<String> getRoleArns() {
        return this.roleArns;
    }

    public void setRoleArns(Collection<String> roleArns) {
        if (roleArns == null) {
            this.roleArns = null;
            return;
        }
        this.roleArns = new ArrayList<String>(roleArns);
    }

    public TokenData withRoleArns(String ... roleArns) {
        if (this.roleArns == null) {
            this.setRoleArns(new ArrayList<String>(roleArns.length));
        }
        for (String ele : roleArns) {
            this.roleArns.add(ele);
        }
        return this;
    }

    public TokenData withRoleArns(Collection<String> roleArns) {
        this.setRoleArns(roleArns);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public TokenData withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTokenId() != null) {
            sb.append("TokenId: ").append(this.getTokenId()).append(",");
        }
        if (this.getTokenType() != null) {
            sb.append("TokenType: ").append(this.getTokenType()).append(",");
        }
        if (this.getLicenseArn() != null) {
            sb.append("LicenseArn: ").append(this.getLicenseArn()).append(",");
        }
        if (this.getExpirationTime() != null) {
            sb.append("ExpirationTime: ").append(this.getExpirationTime()).append(",");
        }
        if (this.getTokenProperties() != null) {
            sb.append("TokenProperties: ").append(this.getTokenProperties()).append(",");
        }
        if (this.getRoleArns() != null) {
            sb.append("RoleArns: ").append(this.getRoleArns()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TokenData)) {
            return false;
        }
        TokenData other = (TokenData)obj;
        if (other.getTokenId() == null ^ this.getTokenId() == null) {
            return false;
        }
        if (other.getTokenId() != null && !other.getTokenId().equals(this.getTokenId())) {
            return false;
        }
        if (other.getTokenType() == null ^ this.getTokenType() == null) {
            return false;
        }
        if (other.getTokenType() != null && !other.getTokenType().equals(this.getTokenType())) {
            return false;
        }
        if (other.getLicenseArn() == null ^ this.getLicenseArn() == null) {
            return false;
        }
        if (other.getLicenseArn() != null && !other.getLicenseArn().equals(this.getLicenseArn())) {
            return false;
        }
        if (other.getExpirationTime() == null ^ this.getExpirationTime() == null) {
            return false;
        }
        if (other.getExpirationTime() != null && !other.getExpirationTime().equals(this.getExpirationTime())) {
            return false;
        }
        if (other.getTokenProperties() == null ^ this.getTokenProperties() == null) {
            return false;
        }
        if (other.getTokenProperties() != null && !other.getTokenProperties().equals(this.getTokenProperties())) {
            return false;
        }
        if (other.getRoleArns() == null ^ this.getRoleArns() == null) {
            return false;
        }
        if (other.getRoleArns() != null && !other.getRoleArns().equals(this.getRoleArns())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTokenId() == null ? 0 : this.getTokenId().hashCode());
        hashCode = 31 * hashCode + (this.getTokenType() == null ? 0 : this.getTokenType().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseArn() == null ? 0 : this.getLicenseArn().hashCode());
        hashCode = 31 * hashCode + (this.getExpirationTime() == null ? 0 : this.getExpirationTime().hashCode());
        hashCode = 31 * hashCode + (this.getTokenProperties() == null ? 0 : this.getTokenProperties().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArns() == null ? 0 : this.getRoleArns().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public TokenData clone() {
        try {
            return (TokenData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TokenDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

