/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.licensemanager.model.ReportContext;
import com.amazonaws.services.licensemanager.model.ReportFrequency;
import com.amazonaws.services.licensemanager.model.ReportType;
import com.amazonaws.services.licensemanager.model.S3Location;
import com.amazonaws.services.licensemanager.model.Tag;
import com.amazonaws.services.licensemanager.model.transform.ReportGeneratorMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReportGenerator
implements Serializable,
Cloneable,
StructuredPojo {
    private String reportGeneratorName;
    private List<String> reportType;
    private ReportContext reportContext;
    private ReportFrequency reportFrequency;
    private String licenseManagerReportGeneratorArn;
    private String lastRunStatus;
    private String lastRunFailureReason;
    private String lastReportGenerationTime;
    private String reportCreatorAccount;
    private String description;
    private S3Location s3Location;
    private String createTime;
    private List<Tag> tags;

    public void setReportGeneratorName(String reportGeneratorName) {
        this.reportGeneratorName = reportGeneratorName;
    }

    public String getReportGeneratorName() {
        return this.reportGeneratorName;
    }

    public ReportGenerator withReportGeneratorName(String reportGeneratorName) {
        this.setReportGeneratorName(reportGeneratorName);
        return this;
    }

    public List<String> getReportType() {
        return this.reportType;
    }

    public void setReportType(Collection<String> reportType) {
        if (reportType == null) {
            this.reportType = null;
            return;
        }
        this.reportType = new ArrayList<String>(reportType);
    }

    public ReportGenerator withReportType(String ... reportType) {
        if (this.reportType == null) {
            this.setReportType(new ArrayList<String>(reportType.length));
        }
        for (String ele : reportType) {
            this.reportType.add(ele);
        }
        return this;
    }

    public ReportGenerator withReportType(Collection<String> reportType) {
        this.setReportType(reportType);
        return this;
    }

    public ReportGenerator withReportType(ReportType ... reportType) {
        ArrayList<String> reportTypeCopy = new ArrayList<String>(reportType.length);
        for (ReportType value : reportType) {
            reportTypeCopy.add(value.toString());
        }
        if (this.getReportType() == null) {
            this.setReportType(reportTypeCopy);
        } else {
            this.getReportType().addAll(reportTypeCopy);
        }
        return this;
    }

    public void setReportContext(ReportContext reportContext) {
        this.reportContext = reportContext;
    }

    public ReportContext getReportContext() {
        return this.reportContext;
    }

    public ReportGenerator withReportContext(ReportContext reportContext) {
        this.setReportContext(reportContext);
        return this;
    }

    public void setReportFrequency(ReportFrequency reportFrequency) {
        this.reportFrequency = reportFrequency;
    }

    public ReportFrequency getReportFrequency() {
        return this.reportFrequency;
    }

    public ReportGenerator withReportFrequency(ReportFrequency reportFrequency) {
        this.setReportFrequency(reportFrequency);
        return this;
    }

    public void setLicenseManagerReportGeneratorArn(String licenseManagerReportGeneratorArn) {
        this.licenseManagerReportGeneratorArn = licenseManagerReportGeneratorArn;
    }

    public String getLicenseManagerReportGeneratorArn() {
        return this.licenseManagerReportGeneratorArn;
    }

    public ReportGenerator withLicenseManagerReportGeneratorArn(String licenseManagerReportGeneratorArn) {
        this.setLicenseManagerReportGeneratorArn(licenseManagerReportGeneratorArn);
        return this;
    }

    public void setLastRunStatus(String lastRunStatus) {
        this.lastRunStatus = lastRunStatus;
    }

    public String getLastRunStatus() {
        return this.lastRunStatus;
    }

    public ReportGenerator withLastRunStatus(String lastRunStatus) {
        this.setLastRunStatus(lastRunStatus);
        return this;
    }

    public void setLastRunFailureReason(String lastRunFailureReason) {
        this.lastRunFailureReason = lastRunFailureReason;
    }

    public String getLastRunFailureReason() {
        return this.lastRunFailureReason;
    }

    public ReportGenerator withLastRunFailureReason(String lastRunFailureReason) {
        this.setLastRunFailureReason(lastRunFailureReason);
        return this;
    }

    public void setLastReportGenerationTime(String lastReportGenerationTime) {
        this.lastReportGenerationTime = lastReportGenerationTime;
    }

    public String getLastReportGenerationTime() {
        return this.lastReportGenerationTime;
    }

    public ReportGenerator withLastReportGenerationTime(String lastReportGenerationTime) {
        this.setLastReportGenerationTime(lastReportGenerationTime);
        return this;
    }

    public void setReportCreatorAccount(String reportCreatorAccount) {
        this.reportCreatorAccount = reportCreatorAccount;
    }

    public String getReportCreatorAccount() {
        return this.reportCreatorAccount;
    }

    public ReportGenerator withReportCreatorAccount(String reportCreatorAccount) {
        this.setReportCreatorAccount(reportCreatorAccount);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ReportGenerator withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setS3Location(S3Location s3Location) {
        this.s3Location = s3Location;
    }

    public S3Location getS3Location() {
        return this.s3Location;
    }

    public ReportGenerator withS3Location(S3Location s3Location) {
        this.setS3Location(s3Location);
        return this;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public ReportGenerator withCreateTime(String createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public ReportGenerator withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ReportGenerator withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReportGeneratorName() != null) {
            sb.append("ReportGeneratorName: ").append(this.getReportGeneratorName()).append(",");
        }
        if (this.getReportType() != null) {
            sb.append("ReportType: ").append(this.getReportType()).append(",");
        }
        if (this.getReportContext() != null) {
            sb.append("ReportContext: ").append(this.getReportContext()).append(",");
        }
        if (this.getReportFrequency() != null) {
            sb.append("ReportFrequency: ").append(this.getReportFrequency()).append(",");
        }
        if (this.getLicenseManagerReportGeneratorArn() != null) {
            sb.append("LicenseManagerReportGeneratorArn: ").append(this.getLicenseManagerReportGeneratorArn()).append(",");
        }
        if (this.getLastRunStatus() != null) {
            sb.append("LastRunStatus: ").append(this.getLastRunStatus()).append(",");
        }
        if (this.getLastRunFailureReason() != null) {
            sb.append("LastRunFailureReason: ").append(this.getLastRunFailureReason()).append(",");
        }
        if (this.getLastReportGenerationTime() != null) {
            sb.append("LastReportGenerationTime: ").append(this.getLastReportGenerationTime()).append(",");
        }
        if (this.getReportCreatorAccount() != null) {
            sb.append("ReportCreatorAccount: ").append(this.getReportCreatorAccount()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getS3Location() != null) {
            sb.append("S3Location: ").append(this.getS3Location()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportGenerator)) {
            return false;
        }
        ReportGenerator other = (ReportGenerator)obj;
        if (other.getReportGeneratorName() == null ^ this.getReportGeneratorName() == null) {
            return false;
        }
        if (other.getReportGeneratorName() != null && !other.getReportGeneratorName().equals(this.getReportGeneratorName())) {
            return false;
        }
        if (other.getReportType() == null ^ this.getReportType() == null) {
            return false;
        }
        if (other.getReportType() != null && !other.getReportType().equals(this.getReportType())) {
            return false;
        }
        if (other.getReportContext() == null ^ this.getReportContext() == null) {
            return false;
        }
        if (other.getReportContext() != null && !other.getReportContext().equals(this.getReportContext())) {
            return false;
        }
        if (other.getReportFrequency() == null ^ this.getReportFrequency() == null) {
            return false;
        }
        if (other.getReportFrequency() != null && !other.getReportFrequency().equals(this.getReportFrequency())) {
            return false;
        }
        if (other.getLicenseManagerReportGeneratorArn() == null ^ this.getLicenseManagerReportGeneratorArn() == null) {
            return false;
        }
        if (other.getLicenseManagerReportGeneratorArn() != null && !other.getLicenseManagerReportGeneratorArn().equals(this.getLicenseManagerReportGeneratorArn())) {
            return false;
        }
        if (other.getLastRunStatus() == null ^ this.getLastRunStatus() == null) {
            return false;
        }
        if (other.getLastRunStatus() != null && !other.getLastRunStatus().equals(this.getLastRunStatus())) {
            return false;
        }
        if (other.getLastRunFailureReason() == null ^ this.getLastRunFailureReason() == null) {
            return false;
        }
        if (other.getLastRunFailureReason() != null && !other.getLastRunFailureReason().equals(this.getLastRunFailureReason())) {
            return false;
        }
        if (other.getLastReportGenerationTime() == null ^ this.getLastReportGenerationTime() == null) {
            return false;
        }
        if (other.getLastReportGenerationTime() != null && !other.getLastReportGenerationTime().equals(this.getLastReportGenerationTime())) {
            return false;
        }
        if (other.getReportCreatorAccount() == null ^ this.getReportCreatorAccount() == null) {
            return false;
        }
        if (other.getReportCreatorAccount() != null && !other.getReportCreatorAccount().equals(this.getReportCreatorAccount())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getS3Location() == null ^ this.getS3Location() == null) {
            return false;
        }
        if (other.getS3Location() != null && !other.getS3Location().equals(this.getS3Location())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReportGeneratorName() == null ? 0 : this.getReportGeneratorName().hashCode());
        hashCode = 31 * hashCode + (this.getReportType() == null ? 0 : this.getReportType().hashCode());
        hashCode = 31 * hashCode + (this.getReportContext() == null ? 0 : this.getReportContext().hashCode());
        hashCode = 31 * hashCode + (this.getReportFrequency() == null ? 0 : this.getReportFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseManagerReportGeneratorArn() == null ? 0 : this.getLicenseManagerReportGeneratorArn().hashCode());
        hashCode = 31 * hashCode + (this.getLastRunStatus() == null ? 0 : this.getLastRunStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLastRunFailureReason() == null ? 0 : this.getLastRunFailureReason().hashCode());
        hashCode = 31 * hashCode + (this.getLastReportGenerationTime() == null ? 0 : this.getLastReportGenerationTime().hashCode());
        hashCode = 31 * hashCode + (this.getReportCreatorAccount() == null ? 0 : this.getReportCreatorAccount().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getS3Location() == null ? 0 : this.getS3Location().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ReportGenerator clone() {
        try {
            return (ReportGenerator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReportGeneratorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

