/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.licensemanager.model.LicenseCountingType;
import com.amazonaws.services.licensemanager.model.ProductInformation;
import com.amazonaws.services.licensemanager.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateLicenseConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private String licenseCountingType;
    private Long licenseCount;
    private Boolean licenseCountHardLimit;
    private List<String> licenseRules;
    private List<Tag> tags;
    private Boolean disassociateWhenNotFound;
    private List<ProductInformation> productInformationList;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateLicenseConfigurationRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateLicenseConfigurationRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setLicenseCountingType(String licenseCountingType) {
        this.licenseCountingType = licenseCountingType;
    }

    public String getLicenseCountingType() {
        return this.licenseCountingType;
    }

    public CreateLicenseConfigurationRequest withLicenseCountingType(String licenseCountingType) {
        this.setLicenseCountingType(licenseCountingType);
        return this;
    }

    public CreateLicenseConfigurationRequest withLicenseCountingType(LicenseCountingType licenseCountingType) {
        this.licenseCountingType = licenseCountingType.toString();
        return this;
    }

    public void setLicenseCount(Long licenseCount) {
        this.licenseCount = licenseCount;
    }

    public Long getLicenseCount() {
        return this.licenseCount;
    }

    public CreateLicenseConfigurationRequest withLicenseCount(Long licenseCount) {
        this.setLicenseCount(licenseCount);
        return this;
    }

    public void setLicenseCountHardLimit(Boolean licenseCountHardLimit) {
        this.licenseCountHardLimit = licenseCountHardLimit;
    }

    public Boolean getLicenseCountHardLimit() {
        return this.licenseCountHardLimit;
    }

    public CreateLicenseConfigurationRequest withLicenseCountHardLimit(Boolean licenseCountHardLimit) {
        this.setLicenseCountHardLimit(licenseCountHardLimit);
        return this;
    }

    public Boolean isLicenseCountHardLimit() {
        return this.licenseCountHardLimit;
    }

    public List<String> getLicenseRules() {
        return this.licenseRules;
    }

    public void setLicenseRules(Collection<String> licenseRules) {
        if (licenseRules == null) {
            this.licenseRules = null;
            return;
        }
        this.licenseRules = new ArrayList<String>(licenseRules);
    }

    public CreateLicenseConfigurationRequest withLicenseRules(String ... licenseRules) {
        if (this.licenseRules == null) {
            this.setLicenseRules(new ArrayList<String>(licenseRules.length));
        }
        for (String ele : licenseRules) {
            this.licenseRules.add(ele);
        }
        return this;
    }

    public CreateLicenseConfigurationRequest withLicenseRules(Collection<String> licenseRules) {
        this.setLicenseRules(licenseRules);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateLicenseConfigurationRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateLicenseConfigurationRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setDisassociateWhenNotFound(Boolean disassociateWhenNotFound) {
        this.disassociateWhenNotFound = disassociateWhenNotFound;
    }

    public Boolean getDisassociateWhenNotFound() {
        return this.disassociateWhenNotFound;
    }

    public CreateLicenseConfigurationRequest withDisassociateWhenNotFound(Boolean disassociateWhenNotFound) {
        this.setDisassociateWhenNotFound(disassociateWhenNotFound);
        return this;
    }

    public Boolean isDisassociateWhenNotFound() {
        return this.disassociateWhenNotFound;
    }

    public List<ProductInformation> getProductInformationList() {
        return this.productInformationList;
    }

    public void setProductInformationList(Collection<ProductInformation> productInformationList) {
        if (productInformationList == null) {
            this.productInformationList = null;
            return;
        }
        this.productInformationList = new ArrayList<ProductInformation>(productInformationList);
    }

    public CreateLicenseConfigurationRequest withProductInformationList(ProductInformation ... productInformationList) {
        if (this.productInformationList == null) {
            this.setProductInformationList(new ArrayList<ProductInformation>(productInformationList.length));
        }
        for (ProductInformation ele : productInformationList) {
            this.productInformationList.add(ele);
        }
        return this;
    }

    public CreateLicenseConfigurationRequest withProductInformationList(Collection<ProductInformation> productInformationList) {
        this.setProductInformationList(productInformationList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getLicenseCountingType() != null) {
            sb.append("LicenseCountingType: ").append(this.getLicenseCountingType()).append(",");
        }
        if (this.getLicenseCount() != null) {
            sb.append("LicenseCount: ").append(this.getLicenseCount()).append(",");
        }
        if (this.getLicenseCountHardLimit() != null) {
            sb.append("LicenseCountHardLimit: ").append(this.getLicenseCountHardLimit()).append(",");
        }
        if (this.getLicenseRules() != null) {
            sb.append("LicenseRules: ").append(this.getLicenseRules()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getDisassociateWhenNotFound() != null) {
            sb.append("DisassociateWhenNotFound: ").append(this.getDisassociateWhenNotFound()).append(",");
        }
        if (this.getProductInformationList() != null) {
            sb.append("ProductInformationList: ").append(this.getProductInformationList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseConfigurationRequest)) {
            return false;
        }
        CreateLicenseConfigurationRequest other = (CreateLicenseConfigurationRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getLicenseCountingType() == null ^ this.getLicenseCountingType() == null) {
            return false;
        }
        if (other.getLicenseCountingType() != null && !other.getLicenseCountingType().equals(this.getLicenseCountingType())) {
            return false;
        }
        if (other.getLicenseCount() == null ^ this.getLicenseCount() == null) {
            return false;
        }
        if (other.getLicenseCount() != null && !other.getLicenseCount().equals(this.getLicenseCount())) {
            return false;
        }
        if (other.getLicenseCountHardLimit() == null ^ this.getLicenseCountHardLimit() == null) {
            return false;
        }
        if (other.getLicenseCountHardLimit() != null && !other.getLicenseCountHardLimit().equals(this.getLicenseCountHardLimit())) {
            return false;
        }
        if (other.getLicenseRules() == null ^ this.getLicenseRules() == null) {
            return false;
        }
        if (other.getLicenseRules() != null && !other.getLicenseRules().equals(this.getLicenseRules())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getDisassociateWhenNotFound() == null ^ this.getDisassociateWhenNotFound() == null) {
            return false;
        }
        if (other.getDisassociateWhenNotFound() != null && !other.getDisassociateWhenNotFound().equals(this.getDisassociateWhenNotFound())) {
            return false;
        }
        if (other.getProductInformationList() == null ^ this.getProductInformationList() == null) {
            return false;
        }
        return other.getProductInformationList() == null || other.getProductInformationList().equals(this.getProductInformationList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseCountingType() == null ? 0 : this.getLicenseCountingType().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseCount() == null ? 0 : this.getLicenseCount().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseCountHardLimit() == null ? 0 : this.getLicenseCountHardLimit().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseRules() == null ? 0 : this.getLicenseRules().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getDisassociateWhenNotFound() == null ? 0 : this.getDisassociateWhenNotFound().hashCode());
        hashCode = 31 * hashCode + (this.getProductInformationList() == null ? 0 : this.getProductInformationList().hashCode());
        return hashCode;
    }

    @Override
    public CreateLicenseConfigurationRequest clone() {
        return (CreateLicenseConfigurationRequest)super.clone();
    }
}

