/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.logging;

import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.api.client.logging.LogSink;
import java.nio.charset.StandardCharsets;

public class LambdaContextLogger
implements LambdaLogger {
    private static final byte[] NULL_BYTES_VALUE = "null".getBytes(StandardCharsets.UTF_8);
    private final transient LogSink sink;

    public LambdaContextLogger(LogSink sink) {
        this.sink = sink;
    }

    @Override
    public void log(byte[] message) {
        if (message == null) {
            message = NULL_BYTES_VALUE;
        }
        this.sink.log(message);
    }

    @Override
    public void log(String message) {
        if (message == null) {
            this.log(NULL_BYTES_VALUE);
        } else {
            this.log(message.getBytes(StandardCharsets.UTF_8));
        }
    }
}

