/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.S3SourceProperties;

@SdkInternalApi
public class S3SourcePropertiesMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketName").build();
    private static final MarshallingInfo<String> BUCKETPREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketPrefix").build();
    private static final MarshallingInfo<StructuredPojo> S3INPUTFORMATCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3InputFormatConfig").build();
    private static final S3SourcePropertiesMarshaller instance = new S3SourcePropertiesMarshaller();

    public static S3SourcePropertiesMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3SourceProperties s3SourceProperties, ProtocolMarshaller protocolMarshaller) {
        if (s3SourceProperties == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3SourceProperties.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall(s3SourceProperties.getBucketPrefix(), BUCKETPREFIX_BINDING);
            protocolMarshaller.marshall(s3SourceProperties.getS3InputFormatConfig(), S3INPUTFORMATCONFIG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

