/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.Operator;
import com.amazonaws.services.appflow.model.Range;
import com.amazonaws.services.appflow.model.transform.FieldTypeDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FieldTypeDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private String fieldType;
    private List<String> filterOperators;
    private List<String> supportedValues;
    private String valueRegexPattern;
    private String supportedDateFormat;
    private Range fieldValueRange;
    private Range fieldLengthRange;

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public FieldTypeDetails withFieldType(String fieldType) {
        this.setFieldType(fieldType);
        return this;
    }

    public List<String> getFilterOperators() {
        return this.filterOperators;
    }

    public void setFilterOperators(Collection<String> filterOperators) {
        if (filterOperators == null) {
            this.filterOperators = null;
            return;
        }
        this.filterOperators = new ArrayList<String>(filterOperators);
    }

    public FieldTypeDetails withFilterOperators(String ... filterOperators) {
        if (this.filterOperators == null) {
            this.setFilterOperators(new ArrayList<String>(filterOperators.length));
        }
        for (String ele : filterOperators) {
            this.filterOperators.add(ele);
        }
        return this;
    }

    public FieldTypeDetails withFilterOperators(Collection<String> filterOperators) {
        this.setFilterOperators(filterOperators);
        return this;
    }

    public FieldTypeDetails withFilterOperators(Operator ... filterOperators) {
        ArrayList<String> filterOperatorsCopy = new ArrayList<String>(filterOperators.length);
        for (Operator value : filterOperators) {
            filterOperatorsCopy.add(value.toString());
        }
        if (this.getFilterOperators() == null) {
            this.setFilterOperators(filterOperatorsCopy);
        } else {
            this.getFilterOperators().addAll(filterOperatorsCopy);
        }
        return this;
    }

    public List<String> getSupportedValues() {
        return this.supportedValues;
    }

    public void setSupportedValues(Collection<String> supportedValues) {
        if (supportedValues == null) {
            this.supportedValues = null;
            return;
        }
        this.supportedValues = new ArrayList<String>(supportedValues);
    }

    public FieldTypeDetails withSupportedValues(String ... supportedValues) {
        if (this.supportedValues == null) {
            this.setSupportedValues(new ArrayList<String>(supportedValues.length));
        }
        for (String ele : supportedValues) {
            this.supportedValues.add(ele);
        }
        return this;
    }

    public FieldTypeDetails withSupportedValues(Collection<String> supportedValues) {
        this.setSupportedValues(supportedValues);
        return this;
    }

    public void setValueRegexPattern(String valueRegexPattern) {
        this.valueRegexPattern = valueRegexPattern;
    }

    public String getValueRegexPattern() {
        return this.valueRegexPattern;
    }

    public FieldTypeDetails withValueRegexPattern(String valueRegexPattern) {
        this.setValueRegexPattern(valueRegexPattern);
        return this;
    }

    public void setSupportedDateFormat(String supportedDateFormat) {
        this.supportedDateFormat = supportedDateFormat;
    }

    public String getSupportedDateFormat() {
        return this.supportedDateFormat;
    }

    public FieldTypeDetails withSupportedDateFormat(String supportedDateFormat) {
        this.setSupportedDateFormat(supportedDateFormat);
        return this;
    }

    public void setFieldValueRange(Range fieldValueRange) {
        this.fieldValueRange = fieldValueRange;
    }

    public Range getFieldValueRange() {
        return this.fieldValueRange;
    }

    public FieldTypeDetails withFieldValueRange(Range fieldValueRange) {
        this.setFieldValueRange(fieldValueRange);
        return this;
    }

    public void setFieldLengthRange(Range fieldLengthRange) {
        this.fieldLengthRange = fieldLengthRange;
    }

    public Range getFieldLengthRange() {
        return this.fieldLengthRange;
    }

    public FieldTypeDetails withFieldLengthRange(Range fieldLengthRange) {
        this.setFieldLengthRange(fieldLengthRange);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFieldType() != null) {
            sb.append("FieldType: ").append(this.getFieldType()).append(",");
        }
        if (this.getFilterOperators() != null) {
            sb.append("FilterOperators: ").append(this.getFilterOperators()).append(",");
        }
        if (this.getSupportedValues() != null) {
            sb.append("SupportedValues: ").append(this.getSupportedValues()).append(",");
        }
        if (this.getValueRegexPattern() != null) {
            sb.append("ValueRegexPattern: ").append(this.getValueRegexPattern()).append(",");
        }
        if (this.getSupportedDateFormat() != null) {
            sb.append("SupportedDateFormat: ").append(this.getSupportedDateFormat()).append(",");
        }
        if (this.getFieldValueRange() != null) {
            sb.append("FieldValueRange: ").append(this.getFieldValueRange()).append(",");
        }
        if (this.getFieldLengthRange() != null) {
            sb.append("FieldLengthRange: ").append(this.getFieldLengthRange());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldTypeDetails)) {
            return false;
        }
        FieldTypeDetails other = (FieldTypeDetails)obj;
        if (other.getFieldType() == null ^ this.getFieldType() == null) {
            return false;
        }
        if (other.getFieldType() != null && !other.getFieldType().equals(this.getFieldType())) {
            return false;
        }
        if (other.getFilterOperators() == null ^ this.getFilterOperators() == null) {
            return false;
        }
        if (other.getFilterOperators() != null && !other.getFilterOperators().equals(this.getFilterOperators())) {
            return false;
        }
        if (other.getSupportedValues() == null ^ this.getSupportedValues() == null) {
            return false;
        }
        if (other.getSupportedValues() != null && !other.getSupportedValues().equals(this.getSupportedValues())) {
            return false;
        }
        if (other.getValueRegexPattern() == null ^ this.getValueRegexPattern() == null) {
            return false;
        }
        if (other.getValueRegexPattern() != null && !other.getValueRegexPattern().equals(this.getValueRegexPattern())) {
            return false;
        }
        if (other.getSupportedDateFormat() == null ^ this.getSupportedDateFormat() == null) {
            return false;
        }
        if (other.getSupportedDateFormat() != null && !other.getSupportedDateFormat().equals(this.getSupportedDateFormat())) {
            return false;
        }
        if (other.getFieldValueRange() == null ^ this.getFieldValueRange() == null) {
            return false;
        }
        if (other.getFieldValueRange() != null && !other.getFieldValueRange().equals(this.getFieldValueRange())) {
            return false;
        }
        if (other.getFieldLengthRange() == null ^ this.getFieldLengthRange() == null) {
            return false;
        }
        return other.getFieldLengthRange() == null || other.getFieldLengthRange().equals(this.getFieldLengthRange());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFieldType() == null ? 0 : this.getFieldType().hashCode());
        hashCode = 31 * hashCode + (this.getFilterOperators() == null ? 0 : this.getFilterOperators().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedValues() == null ? 0 : this.getSupportedValues().hashCode());
        hashCode = 31 * hashCode + (this.getValueRegexPattern() == null ? 0 : this.getValueRegexPattern().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedDateFormat() == null ? 0 : this.getSupportedDateFormat().hashCode());
        hashCode = 31 * hashCode + (this.getFieldValueRange() == null ? 0 : this.getFieldValueRange().hashCode());
        hashCode = 31 * hashCode + (this.getFieldLengthRange() == null ? 0 : this.getFieldLengthRange().hashCode());
        return hashCode;
    }

    public FieldTypeDetails clone() {
        try {
            return (FieldTypeDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FieldTypeDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

