/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appflow.model.DestinationFlowConfig;
import com.amazonaws.services.appflow.model.SourceFlowConfig;
import com.amazonaws.services.appflow.model.Task;
import com.amazonaws.services.appflow.model.TriggerConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateFlowRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String flowName;
    private String description;
    private String kmsArn;
    private TriggerConfig triggerConfig;
    private SourceFlowConfig sourceFlowConfig;
    private List<DestinationFlowConfig> destinationFlowConfigList;
    private List<Task> tasks;
    private Map<String, String> tags;

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public CreateFlowRequest withFlowName(String flowName) {
        this.setFlowName(flowName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateFlowRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setKmsArn(String kmsArn) {
        this.kmsArn = kmsArn;
    }

    public String getKmsArn() {
        return this.kmsArn;
    }

    public CreateFlowRequest withKmsArn(String kmsArn) {
        this.setKmsArn(kmsArn);
        return this;
    }

    public void setTriggerConfig(TriggerConfig triggerConfig) {
        this.triggerConfig = triggerConfig;
    }

    public TriggerConfig getTriggerConfig() {
        return this.triggerConfig;
    }

    public CreateFlowRequest withTriggerConfig(TriggerConfig triggerConfig) {
        this.setTriggerConfig(triggerConfig);
        return this;
    }

    public void setSourceFlowConfig(SourceFlowConfig sourceFlowConfig) {
        this.sourceFlowConfig = sourceFlowConfig;
    }

    public SourceFlowConfig getSourceFlowConfig() {
        return this.sourceFlowConfig;
    }

    public CreateFlowRequest withSourceFlowConfig(SourceFlowConfig sourceFlowConfig) {
        this.setSourceFlowConfig(sourceFlowConfig);
        return this;
    }

    public List<DestinationFlowConfig> getDestinationFlowConfigList() {
        return this.destinationFlowConfigList;
    }

    public void setDestinationFlowConfigList(Collection<DestinationFlowConfig> destinationFlowConfigList) {
        if (destinationFlowConfigList == null) {
            this.destinationFlowConfigList = null;
            return;
        }
        this.destinationFlowConfigList = new ArrayList<DestinationFlowConfig>(destinationFlowConfigList);
    }

    public CreateFlowRequest withDestinationFlowConfigList(DestinationFlowConfig ... destinationFlowConfigList) {
        if (this.destinationFlowConfigList == null) {
            this.setDestinationFlowConfigList(new ArrayList<DestinationFlowConfig>(destinationFlowConfigList.length));
        }
        for (DestinationFlowConfig ele : destinationFlowConfigList) {
            this.destinationFlowConfigList.add(ele);
        }
        return this;
    }

    public CreateFlowRequest withDestinationFlowConfigList(Collection<DestinationFlowConfig> destinationFlowConfigList) {
        this.setDestinationFlowConfigList(destinationFlowConfigList);
        return this;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(Collection<Task> tasks) {
        if (tasks == null) {
            this.tasks = null;
            return;
        }
        this.tasks = new ArrayList<Task>(tasks);
    }

    public CreateFlowRequest withTasks(Task ... tasks) {
        if (this.tasks == null) {
            this.setTasks(new ArrayList<Task>(tasks.length));
        }
        for (Task ele : tasks) {
            this.tasks.add(ele);
        }
        return this;
    }

    public CreateFlowRequest withTasks(Collection<Task> tasks) {
        this.setTasks(tasks);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateFlowRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateFlowRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateFlowRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFlowName() != null) {
            sb.append("FlowName: ").append(this.getFlowName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getKmsArn() != null) {
            sb.append("KmsArn: ").append(this.getKmsArn()).append(",");
        }
        if (this.getTriggerConfig() != null) {
            sb.append("TriggerConfig: ").append(this.getTriggerConfig()).append(",");
        }
        if (this.getSourceFlowConfig() != null) {
            sb.append("SourceFlowConfig: ").append(this.getSourceFlowConfig()).append(",");
        }
        if (this.getDestinationFlowConfigList() != null) {
            sb.append("DestinationFlowConfigList: ").append(this.getDestinationFlowConfigList()).append(",");
        }
        if (this.getTasks() != null) {
            sb.append("Tasks: ").append(this.getTasks()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowRequest)) {
            return false;
        }
        CreateFlowRequest other = (CreateFlowRequest)obj;
        if (other.getFlowName() == null ^ this.getFlowName() == null) {
            return false;
        }
        if (other.getFlowName() != null && !other.getFlowName().equals(this.getFlowName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getKmsArn() == null ^ this.getKmsArn() == null) {
            return false;
        }
        if (other.getKmsArn() != null && !other.getKmsArn().equals(this.getKmsArn())) {
            return false;
        }
        if (other.getTriggerConfig() == null ^ this.getTriggerConfig() == null) {
            return false;
        }
        if (other.getTriggerConfig() != null && !other.getTriggerConfig().equals(this.getTriggerConfig())) {
            return false;
        }
        if (other.getSourceFlowConfig() == null ^ this.getSourceFlowConfig() == null) {
            return false;
        }
        if (other.getSourceFlowConfig() != null && !other.getSourceFlowConfig().equals(this.getSourceFlowConfig())) {
            return false;
        }
        if (other.getDestinationFlowConfigList() == null ^ this.getDestinationFlowConfigList() == null) {
            return false;
        }
        if (other.getDestinationFlowConfigList() != null && !other.getDestinationFlowConfigList().equals(this.getDestinationFlowConfigList())) {
            return false;
        }
        if (other.getTasks() == null ^ this.getTasks() == null) {
            return false;
        }
        if (other.getTasks() != null && !other.getTasks().equals(this.getTasks())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFlowName() == null ? 0 : this.getFlowName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getKmsArn() == null ? 0 : this.getKmsArn().hashCode());
        hashCode = 31 * hashCode + (this.getTriggerConfig() == null ? 0 : this.getTriggerConfig().hashCode());
        hashCode = 31 * hashCode + (this.getSourceFlowConfig() == null ? 0 : this.getSourceFlowConfig().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationFlowConfigList() == null ? 0 : this.getDestinationFlowConfigList().hashCode());
        hashCode = 31 * hashCode + (this.getTasks() == null ? 0 : this.getTasks().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateFlowRequest clone() {
        return (CreateFlowRequest)super.clone();
    }
}

