/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.CustomAuthConfig;
import com.amazonaws.services.appflow.model.OAuth2Defaults;
import com.amazonaws.services.appflow.model.transform.AuthenticationConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AuthenticationConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean isBasicAuthSupported;
    private Boolean isApiKeyAuthSupported;
    private Boolean isOAuth2Supported;
    private Boolean isCustomAuthSupported;
    private OAuth2Defaults oAuth2Defaults;
    private List<CustomAuthConfig> customAuthConfigs;

    public void setIsBasicAuthSupported(Boolean isBasicAuthSupported) {
        this.isBasicAuthSupported = isBasicAuthSupported;
    }

    public Boolean getIsBasicAuthSupported() {
        return this.isBasicAuthSupported;
    }

    public AuthenticationConfig withIsBasicAuthSupported(Boolean isBasicAuthSupported) {
        this.setIsBasicAuthSupported(isBasicAuthSupported);
        return this;
    }

    public Boolean isBasicAuthSupported() {
        return this.isBasicAuthSupported;
    }

    public void setIsApiKeyAuthSupported(Boolean isApiKeyAuthSupported) {
        this.isApiKeyAuthSupported = isApiKeyAuthSupported;
    }

    public Boolean getIsApiKeyAuthSupported() {
        return this.isApiKeyAuthSupported;
    }

    public AuthenticationConfig withIsApiKeyAuthSupported(Boolean isApiKeyAuthSupported) {
        this.setIsApiKeyAuthSupported(isApiKeyAuthSupported);
        return this;
    }

    public Boolean isApiKeyAuthSupported() {
        return this.isApiKeyAuthSupported;
    }

    public void setIsOAuth2Supported(Boolean isOAuth2Supported) {
        this.isOAuth2Supported = isOAuth2Supported;
    }

    public Boolean getIsOAuth2Supported() {
        return this.isOAuth2Supported;
    }

    public AuthenticationConfig withIsOAuth2Supported(Boolean isOAuth2Supported) {
        this.setIsOAuth2Supported(isOAuth2Supported);
        return this;
    }

    public Boolean isOAuth2Supported() {
        return this.isOAuth2Supported;
    }

    public void setIsCustomAuthSupported(Boolean isCustomAuthSupported) {
        this.isCustomAuthSupported = isCustomAuthSupported;
    }

    public Boolean getIsCustomAuthSupported() {
        return this.isCustomAuthSupported;
    }

    public AuthenticationConfig withIsCustomAuthSupported(Boolean isCustomAuthSupported) {
        this.setIsCustomAuthSupported(isCustomAuthSupported);
        return this;
    }

    public Boolean isCustomAuthSupported() {
        return this.isCustomAuthSupported;
    }

    public void setOAuth2Defaults(OAuth2Defaults oAuth2Defaults) {
        this.oAuth2Defaults = oAuth2Defaults;
    }

    public OAuth2Defaults getOAuth2Defaults() {
        return this.oAuth2Defaults;
    }

    public AuthenticationConfig withOAuth2Defaults(OAuth2Defaults oAuth2Defaults) {
        this.setOAuth2Defaults(oAuth2Defaults);
        return this;
    }

    public List<CustomAuthConfig> getCustomAuthConfigs() {
        return this.customAuthConfigs;
    }

    public void setCustomAuthConfigs(Collection<CustomAuthConfig> customAuthConfigs) {
        if (customAuthConfigs == null) {
            this.customAuthConfigs = null;
            return;
        }
        this.customAuthConfigs = new ArrayList<CustomAuthConfig>(customAuthConfigs);
    }

    public AuthenticationConfig withCustomAuthConfigs(CustomAuthConfig ... customAuthConfigs) {
        if (this.customAuthConfigs == null) {
            this.setCustomAuthConfigs(new ArrayList<CustomAuthConfig>(customAuthConfigs.length));
        }
        for (CustomAuthConfig ele : customAuthConfigs) {
            this.customAuthConfigs.add(ele);
        }
        return this;
    }

    public AuthenticationConfig withCustomAuthConfigs(Collection<CustomAuthConfig> customAuthConfigs) {
        this.setCustomAuthConfigs(customAuthConfigs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIsBasicAuthSupported() != null) {
            sb.append("IsBasicAuthSupported: ").append(this.getIsBasicAuthSupported()).append(",");
        }
        if (this.getIsApiKeyAuthSupported() != null) {
            sb.append("IsApiKeyAuthSupported: ").append(this.getIsApiKeyAuthSupported()).append(",");
        }
        if (this.getIsOAuth2Supported() != null) {
            sb.append("IsOAuth2Supported: ").append(this.getIsOAuth2Supported()).append(",");
        }
        if (this.getIsCustomAuthSupported() != null) {
            sb.append("IsCustomAuthSupported: ").append(this.getIsCustomAuthSupported()).append(",");
        }
        if (this.getOAuth2Defaults() != null) {
            sb.append("OAuth2Defaults: ").append(this.getOAuth2Defaults()).append(",");
        }
        if (this.getCustomAuthConfigs() != null) {
            sb.append("CustomAuthConfigs: ").append(this.getCustomAuthConfigs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfig)) {
            return false;
        }
        AuthenticationConfig other = (AuthenticationConfig)obj;
        if (other.getIsBasicAuthSupported() == null ^ this.getIsBasicAuthSupported() == null) {
            return false;
        }
        if (other.getIsBasicAuthSupported() != null && !other.getIsBasicAuthSupported().equals(this.getIsBasicAuthSupported())) {
            return false;
        }
        if (other.getIsApiKeyAuthSupported() == null ^ this.getIsApiKeyAuthSupported() == null) {
            return false;
        }
        if (other.getIsApiKeyAuthSupported() != null && !other.getIsApiKeyAuthSupported().equals(this.getIsApiKeyAuthSupported())) {
            return false;
        }
        if (other.getIsOAuth2Supported() == null ^ this.getIsOAuth2Supported() == null) {
            return false;
        }
        if (other.getIsOAuth2Supported() != null && !other.getIsOAuth2Supported().equals(this.getIsOAuth2Supported())) {
            return false;
        }
        if (other.getIsCustomAuthSupported() == null ^ this.getIsCustomAuthSupported() == null) {
            return false;
        }
        if (other.getIsCustomAuthSupported() != null && !other.getIsCustomAuthSupported().equals(this.getIsCustomAuthSupported())) {
            return false;
        }
        if (other.getOAuth2Defaults() == null ^ this.getOAuth2Defaults() == null) {
            return false;
        }
        if (other.getOAuth2Defaults() != null && !other.getOAuth2Defaults().equals(this.getOAuth2Defaults())) {
            return false;
        }
        if (other.getCustomAuthConfigs() == null ^ this.getCustomAuthConfigs() == null) {
            return false;
        }
        return other.getCustomAuthConfigs() == null || other.getCustomAuthConfigs().equals(this.getCustomAuthConfigs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIsBasicAuthSupported() == null ? 0 : this.getIsBasicAuthSupported().hashCode());
        hashCode = 31 * hashCode + (this.getIsApiKeyAuthSupported() == null ? 0 : this.getIsApiKeyAuthSupported().hashCode());
        hashCode = 31 * hashCode + (this.getIsOAuth2Supported() == null ? 0 : this.getIsOAuth2Supported().hashCode());
        hashCode = 31 * hashCode + (this.getIsCustomAuthSupported() == null ? 0 : this.getIsCustomAuthSupported().hashCode());
        hashCode = 31 * hashCode + (this.getOAuth2Defaults() == null ? 0 : this.getOAuth2Defaults().hashCode());
        hashCode = 31 * hashCode + (this.getCustomAuthConfigs() == null ? 0 : this.getCustomAuthConfigs().hashCode());
        return hashCode;
    }

    public AuthenticationConfig clone() {
        try {
            return (AuthenticationConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuthenticationConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

