/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.settings;

import com.amazonaws.appflow.custom.connector.model.settings.ConnectorRuntimeSettingScope;
import com.amazonaws.appflow.custom.connector.model.settings.ValidateConnectorRuntimeSettingsRequest;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@JsonTypeName(value="ValidateConnectorRuntimeSettingsRequest")
@Generated(from="ValidateConnectorRuntimeSettingsRequest", generator="Immutables")
@Immutable
public final class ImmutableValidateConnectorRuntimeSettingsRequest
implements ValidateConnectorRuntimeSettingsRequest {
    private final ConnectorRuntimeSettingScope scope;
    private final Map<String, String> connectorRuntimeSettings;

    private ImmutableValidateConnectorRuntimeSettingsRequest(ConnectorRuntimeSettingScope scope, Map<String, String> connectorRuntimeSettings) {
        this.scope = scope;
        this.connectorRuntimeSettings = connectorRuntimeSettings;
    }

    @Override
    @JsonProperty(value="scope")
    public ConnectorRuntimeSettingScope scope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="connectorRuntimeSettings")
    public Map<String, String> connectorRuntimeSettings() {
        return this.connectorRuntimeSettings;
    }

    public final ImmutableValidateConnectorRuntimeSettingsRequest withScope(ConnectorRuntimeSettingScope value) {
        ConnectorRuntimeSettingScope newValue = Objects.requireNonNull(value, "scope");
        if (this.scope == newValue) {
            return this;
        }
        return new ImmutableValidateConnectorRuntimeSettingsRequest(newValue, this.connectorRuntimeSettings);
    }

    public final ImmutableValidateConnectorRuntimeSettingsRequest withConnectorRuntimeSettings(Map<String, ? extends String> entries) {
        if (this.connectorRuntimeSettings == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableValidateConnectorRuntimeSettingsRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutableValidateConnectorRuntimeSettingsRequest(this.scope, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValidateConnectorRuntimeSettingsRequest && this.equalTo(0, (ImmutableValidateConnectorRuntimeSettingsRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableValidateConnectorRuntimeSettingsRequest another) {
        return this.scope.equals((Object)another.scope) && this.connectorRuntimeSettings.equals(another.connectorRuntimeSettings);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.scope.hashCode();
        h2 += (h2 << 5) + this.connectorRuntimeSettings.hashCode();
        return h2;
    }

    public String toString() {
        return "ValidateConnectorRuntimeSettingsRequest{scope=" + (Object)((Object)this.scope) + ", connectorRuntimeSettings=" + this.connectorRuntimeSettings + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableValidateConnectorRuntimeSettingsRequest fromJson(Json json) {
        Builder builder = ImmutableValidateConnectorRuntimeSettingsRequest.builder();
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.connectorRuntimeSettings != null) {
            builder.putAllConnectorRuntimeSettings(json.connectorRuntimeSettings);
        }
        return builder.build();
    }

    public static ImmutableValidateConnectorRuntimeSettingsRequest copyOf(ValidateConnectorRuntimeSettingsRequest instance) {
        if (instance instanceof ImmutableValidateConnectorRuntimeSettingsRequest) {
            return (ImmutableValidateConnectorRuntimeSettingsRequest)instance;
        }
        return ImmutableValidateConnectorRuntimeSettingsRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ValidateConnectorRuntimeSettingsRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SCOPE = 1L;
        private long initBits = 1L;
        @Nullable
        private ConnectorRuntimeSettingScope scope;
        private Map<String, String> connectorRuntimeSettings = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public final Builder from(ValidateConnectorRuntimeSettingsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.scope(instance.scope());
            this.putAllConnectorRuntimeSettings(instance.connectorRuntimeSettings());
            return this;
        }

        @JsonProperty(value="scope")
        public final Builder scope(ConnectorRuntimeSettingScope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putConnectorRuntimeSettings(String key, String value) {
            this.connectorRuntimeSettings.put(Objects.requireNonNull(key, "connectorRuntimeSettings key"), Objects.requireNonNull(value, "connectorRuntimeSettings value"));
            return this;
        }

        public final Builder putConnectorRuntimeSettings(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.connectorRuntimeSettings.put(Objects.requireNonNull(k, "connectorRuntimeSettings key"), Objects.requireNonNull(v, "connectorRuntimeSettings value"));
            return this;
        }

        @JsonProperty(value="connectorRuntimeSettings")
        public final Builder connectorRuntimeSettings(Map<String, ? extends String> entries) {
            this.connectorRuntimeSettings.clear();
            return this.putAllConnectorRuntimeSettings(entries);
        }

        public final Builder putAllConnectorRuntimeSettings(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.connectorRuntimeSettings.put(Objects.requireNonNull(k, "connectorRuntimeSettings key"), Objects.requireNonNull(v, "connectorRuntimeSettings value"));
            }
            return this;
        }

        public ImmutableValidateConnectorRuntimeSettingsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValidateConnectorRuntimeSettingsRequest(this.scope, ImmutableValidateConnectorRuntimeSettingsRequest.createUnmodifiableMap(false, false, this.connectorRuntimeSettings));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scope");
            }
            return "Cannot build ValidateConnectorRuntimeSettingsRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ValidateConnectorRuntimeSettingsRequest", generator="Immutables")
    static final class Json
    implements ValidateConnectorRuntimeSettingsRequest {
        @Nullable
        ConnectorRuntimeSettingScope scope;
        @Nullable
        Map<String, String> connectorRuntimeSettings = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(ConnectorRuntimeSettingScope scope) {
            this.scope = scope;
        }

        @JsonProperty(value="connectorRuntimeSettings")
        public void setConnectorRuntimeSettings(Map<String, String> connectorRuntimeSettings) {
            this.connectorRuntimeSettings = connectorRuntimeSettings;
        }

        @Override
        public ConnectorRuntimeSettingScope scope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> connectorRuntimeSettings() {
            throw new UnsupportedOperationException();
        }
    }
}

