/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.metadata;

import com.amazonaws.appflow.custom.connector.model.metadata.Entity;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Entity", generator="Immutables")
@Immutable
public final class ImmutableEntity
implements Entity {
    private final String entityIdentifier;
    private final boolean hasNestedEntities;
    @Nullable
    private final String label;
    @Nullable
    private final String description;

    private ImmutableEntity(String entityIdentifier, boolean hasNestedEntities, @Nullable String label, @Nullable String description) {
        this.entityIdentifier = entityIdentifier;
        this.hasNestedEntities = hasNestedEntities;
        this.label = label;
        this.description = description;
    }

    @Override
    @JsonProperty(value="entityIdentifier")
    public String entityIdentifier() {
        return this.entityIdentifier;
    }

    @Override
    @JsonProperty(value="hasNestedEntities")
    public boolean hasNestedEntities() {
        return this.hasNestedEntities;
    }

    @Override
    @JsonProperty(value="label")
    @Nullable
    public String label() {
        return this.label;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    public final ImmutableEntity withEntityIdentifier(String value) {
        String newValue = Objects.requireNonNull(value, "entityIdentifier");
        if (this.entityIdentifier.equals(newValue)) {
            return this;
        }
        return new ImmutableEntity(newValue, this.hasNestedEntities, this.label, this.description);
    }

    public final ImmutableEntity withHasNestedEntities(boolean value) {
        if (this.hasNestedEntities == value) {
            return this;
        }
        return new ImmutableEntity(this.entityIdentifier, value, this.label, this.description);
    }

    public final ImmutableEntity withLabel(@Nullable String value) {
        if (Objects.equals(this.label, value)) {
            return this;
        }
        return new ImmutableEntity(this.entityIdentifier, this.hasNestedEntities, value, this.description);
    }

    public final ImmutableEntity withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableEntity(this.entityIdentifier, this.hasNestedEntities, this.label, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntity && this.equalTo(0, (ImmutableEntity)another);
    }

    private boolean equalTo(int synthetic, ImmutableEntity another) {
        return this.entityIdentifier.equals(another.entityIdentifier) && this.hasNestedEntities == another.hasNestedEntities && Objects.equals(this.label, another.label) && Objects.equals(this.description, another.description);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.entityIdentifier.hashCode();
        h2 += (h2 << 5) + Booleans.hashCode(this.hasNestedEntities);
        h2 += (h2 << 5) + Objects.hashCode(this.label);
        h2 += (h2 << 5) + Objects.hashCode(this.description);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Entity").omitNullValues().add("entityIdentifier", this.entityIdentifier).add("hasNestedEntities", this.hasNestedEntities).add("label", this.label).add("description", this.description).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEntity fromJson(Json json) {
        Builder builder = ImmutableEntity.builder();
        if (json.entityIdentifier != null) {
            builder.entityIdentifier(json.entityIdentifier);
        }
        if (json.hasNestedEntitiesIsSet) {
            builder.hasNestedEntities(json.hasNestedEntities);
        }
        if (json.label != null) {
            builder.label(json.label);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        return builder.build();
    }

    public static ImmutableEntity copyOf(Entity instance) {
        if (instance instanceof ImmutableEntity) {
            return (ImmutableEntity)instance;
        }
        return ImmutableEntity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Entity", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENTITY_IDENTIFIER = 1L;
        private static final long INIT_BIT_HAS_NESTED_ENTITIES = 2L;
        private long initBits = 3L;
        @Nullable
        private String entityIdentifier;
        private boolean hasNestedEntities;
        @Nullable
        private String label;
        @Nullable
        private String description;

        private Builder() {
        }

        public final Builder from(Entity instance) {
            String descriptionValue;
            Objects.requireNonNull(instance, "instance");
            this.entityIdentifier(instance.entityIdentifier());
            this.hasNestedEntities(instance.hasNestedEntities());
            String labelValue = instance.label();
            if (labelValue != null) {
                this.label(labelValue);
            }
            if ((descriptionValue = instance.description()) != null) {
                this.description(descriptionValue);
            }
            return this;
        }

        @JsonProperty(value="entityIdentifier")
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = Objects.requireNonNull(entityIdentifier, "entityIdentifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="hasNestedEntities")
        public final Builder hasNestedEntities(boolean hasNestedEntities) {
            this.hasNestedEntities = hasNestedEntities;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="label")
        public final Builder label(@Nullable String label) {
            this.label = label;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public ImmutableEntity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEntity(this.entityIdentifier, this.hasNestedEntities, this.label, this.description);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("entityIdentifier");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hasNestedEntities");
            }
            return "Cannot build Entity, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Entity", generator="Immutables")
    static final class Json
    implements Entity {
        @Nullable
        String entityIdentifier;
        boolean hasNestedEntities;
        boolean hasNestedEntitiesIsSet;
        @Nullable
        String label;
        @Nullable
        String description;

        Json() {
        }

        @JsonProperty(value="entityIdentifier")
        public void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @JsonProperty(value="hasNestedEntities")
        public void setHasNestedEntities(boolean hasNestedEntities) {
            this.hasNestedEntities = hasNestedEntities;
            this.hasNestedEntitiesIsSet = true;
        }

        @JsonProperty(value="label")
        public void setLabel(@Nullable String label) {
            this.label = label;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @Override
        public String entityIdentifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNestedEntities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String label() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }
    }
}

