/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth;

import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.AuthParameter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AuthParameter", generator="Immutables")
@Immutable
public final class ImmutableAuthParameter
implements AuthParameter {
    private final String key;
    private final boolean required;
    private final String label;
    private final String description;
    @Nullable
    private final Boolean sensitiveField;
    @Nullable
    private final ImmutableList<String> connectorSuppliedValues;

    private ImmutableAuthParameter(String key, boolean required, String label, String description, @Nullable Boolean sensitiveField, @Nullable ImmutableList<String> connectorSuppliedValues) {
        this.key = key;
        this.required = required;
        this.label = label;
        this.description = description;
        this.sensitiveField = sensitiveField;
        this.connectorSuppliedValues = connectorSuppliedValues;
    }

    @Override
    @JsonProperty(value="key")
    public String key() {
        return this.key;
    }

    @Override
    @JsonProperty(value="required")
    public boolean required() {
        return this.required;
    }

    @Override
    @JsonProperty(value="label")
    public String label() {
        return this.label;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="sensitiveField")
    @Nullable
    public Boolean sensitiveField() {
        return this.sensitiveField;
    }

    @JsonProperty(value="connectorSuppliedValues")
    @Nullable
    public ImmutableList<String> connectorSuppliedValues() {
        return this.connectorSuppliedValues;
    }

    public final ImmutableAuthParameter withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthParameter(newValue, this.required, this.label, this.description, this.sensitiveField, this.connectorSuppliedValues);
    }

    public final ImmutableAuthParameter withRequired(boolean value) {
        if (this.required == value) {
            return this;
        }
        return new ImmutableAuthParameter(this.key, value, this.label, this.description, this.sensitiveField, this.connectorSuppliedValues);
    }

    public final ImmutableAuthParameter withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthParameter(this.key, this.required, newValue, this.description, this.sensitiveField, this.connectorSuppliedValues);
    }

    public final ImmutableAuthParameter withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthParameter(this.key, this.required, this.label, newValue, this.sensitiveField, this.connectorSuppliedValues);
    }

    public final ImmutableAuthParameter withSensitiveField(@Nullable Boolean value) {
        if (Objects.equals(this.sensitiveField, value)) {
            return this;
        }
        return new ImmutableAuthParameter(this.key, this.required, this.label, this.description, value, this.connectorSuppliedValues);
    }

    public final ImmutableAuthParameter withConnectorSuppliedValues(String ... elements) {
        if (elements == null) {
            return new ImmutableAuthParameter(this.key, this.required, this.label, this.description, this.sensitiveField, null);
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableAuthParameter(this.key, this.required, this.label, this.description, this.sensitiveField, newValue);
    }

    public final ImmutableAuthParameter withConnectorSuppliedValues(@Nullable Iterable<String> elements) {
        if (this.connectorSuppliedValues == elements) {
            return this;
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableAuthParameter(this.key, this.required, this.label, this.description, this.sensitiveField, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthParameter && this.equalTo(0, (ImmutableAuthParameter)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthParameter another) {
        return this.key.equals(another.key) && this.required == another.required && this.label.equals(another.label) && this.description.equals(another.description) && Objects.equals(this.sensitiveField, another.sensitiveField) && Objects.equals(this.connectorSuppliedValues, another.connectorSuppliedValues);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.key.hashCode();
        h2 += (h2 << 5) + Booleans.hashCode(this.required);
        h2 += (h2 << 5) + this.label.hashCode();
        h2 += (h2 << 5) + this.description.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.sensitiveField);
        h2 += (h2 << 5) + Objects.hashCode(this.connectorSuppliedValues);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AuthParameter").omitNullValues().add("key", this.key).add("required", this.required).add("label", this.label).add("description", this.description).add("sensitiveField", this.sensitiveField).add("connectorSuppliedValues", this.connectorSuppliedValues).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAuthParameter fromJson(Json json) {
        Builder builder = ImmutableAuthParameter.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.requiredIsSet) {
            builder.required(json.required);
        }
        if (json.label != null) {
            builder.label(json.label);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.sensitiveField != null) {
            builder.sensitiveField(json.sensitiveField);
        }
        if (json.connectorSuppliedValues != null) {
            builder.addAllConnectorSuppliedValues(json.connectorSuppliedValues);
        }
        return builder.build();
    }

    public static ImmutableAuthParameter copyOf(AuthParameter instance) {
        if (instance instanceof ImmutableAuthParameter) {
            return (ImmutableAuthParameter)instance;
        }
        return ImmutableAuthParameter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuthParameter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_REQUIRED = 2L;
        private static final long INIT_BIT_LABEL = 4L;
        private static final long INIT_BIT_DESCRIPTION = 8L;
        private long initBits = 15L;
        @Nullable
        private String key;
        private boolean required;
        @Nullable
        private String label;
        @Nullable
        private String description;
        @Nullable
        private Boolean sensitiveField;
        private ImmutableList.Builder<String> connectorSuppliedValues = null;

        private Builder() {
        }

        public final Builder from(AuthParameter instance) {
            List<String> connectorSuppliedValuesValue;
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            this.required(instance.required());
            this.label(instance.label());
            this.description(instance.description());
            Boolean sensitiveFieldValue = instance.sensitiveField();
            if (sensitiveFieldValue != null) {
                this.sensitiveField(sensitiveFieldValue);
            }
            if ((connectorSuppliedValuesValue = instance.connectorSuppliedValues()) != null) {
                this.addAllConnectorSuppliedValues(connectorSuppliedValuesValue);
            }
            return this;
        }

        @JsonProperty(value="key")
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="required")
        public final Builder required(boolean required) {
            this.required = required;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="label")
        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="sensitiveField")
        public final Builder sensitiveField(@Nullable Boolean sensitiveField) {
            this.sensitiveField = sensitiveField;
            return this;
        }

        public final Builder addConnectorSuppliedValues(String element) {
            if (this.connectorSuppliedValues == null) {
                this.connectorSuppliedValues = ImmutableList.builder();
            }
            this.connectorSuppliedValues.add((Object)element);
            return this;
        }

        public final Builder addConnectorSuppliedValues(String ... elements) {
            if (this.connectorSuppliedValues == null) {
                this.connectorSuppliedValues = ImmutableList.builder();
            }
            this.connectorSuppliedValues.add(elements);
            return this;
        }

        @JsonProperty(value="connectorSuppliedValues")
        public final Builder connectorSuppliedValues(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.connectorSuppliedValues = null;
                return this;
            }
            this.connectorSuppliedValues = ImmutableList.builder();
            return this.addAllConnectorSuppliedValues(elements);
        }

        public final Builder addAllConnectorSuppliedValues(Iterable<String> elements) {
            Objects.requireNonNull(elements, "connectorSuppliedValues element");
            if (this.connectorSuppliedValues == null) {
                this.connectorSuppliedValues = ImmutableList.builder();
            }
            this.connectorSuppliedValues.addAll((Iterable)elements);
            return this;
        }

        public ImmutableAuthParameter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthParameter(this.key, this.required, this.label, this.description, this.sensitiveField, (ImmutableList)(this.connectorSuppliedValues == null ? null : this.connectorSuppliedValues.build()));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("required");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("label");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("description");
            }
            return "Cannot build AuthParameter, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AuthParameter", generator="Immutables")
    static final class Json
    implements AuthParameter {
        @Nullable
        String key;
        boolean required;
        boolean requiredIsSet;
        @Nullable
        String label;
        @Nullable
        String description;
        @Nullable
        Boolean sensitiveField;
        @Nullable
        List<String> connectorSuppliedValues = null;

        Json() {
        }

        @JsonProperty(value="key")
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="required")
        public void setRequired(boolean required) {
            this.required = required;
            this.requiredIsSet = true;
        }

        @JsonProperty(value="label")
        public void setLabel(String label) {
            this.label = label;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="sensitiveField")
        public void setSensitiveField(@Nullable Boolean sensitiveField) {
            this.sensitiveField = sensitiveField;
        }

        @JsonProperty(value="connectorSuppliedValues")
        public void setConnectorSuppliedValues(@Nullable List<String> connectorSuppliedValues) {
            this.connectorSuppliedValues = connectorSuppliedValues;
        }

        @Override
        public String key() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean required() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String label() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean sensitiveField() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> connectorSuppliedValues() {
            throw new UnsupportedOperationException();
        }
    }
}

