/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.marketplace;

import com.amazonaws.SdkBaseException;
import com.amazonaws.services.licensemanager.AWSLicenseManager;
import com.amazonaws.services.licensemanager.AWSLicenseManagerClientBuilder;
import com.amazonaws.services.licensemanager.model.CheckoutLicenseRequest;
import com.amazonaws.services.licensemanager.model.CheckoutLicenseResult;
import com.amazonaws.services.licensemanager.model.CheckoutType;
import com.amazonaws.services.licensemanager.model.EntitlementData;
import com.amazonaws.services.licensemanager.model.EntitlementDataUnit;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntitlementUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntitlementUtil.class);
    private static final String KEY_FINGERPRINT = "aws:294406891311:AWS/Marketplace:issuer-fingerprint";
    private static final String AWS_MARKETPLACE_USAGE_ENTITLEMENT_NAME = "AWS::Marketplace::Usage";
    private static AWSLicenseManager client;

    public EntitlementUtil() {
        client = AWSLicenseManagerClientBuilder.defaultClient();
    }

    public boolean checkEntitlement(String productSKU) {
        CheckoutLicenseRequest request = new CheckoutLicenseRequest().withCheckoutType(CheckoutType.PROVISIONAL).withProductSKU(productSKU).withKeyFingerprint(KEY_FINGERPRINT).withEntitlements(Collections.singleton(EntitlementUtil.getMarketplaceUsageEntitlement())).withClientToken(UUID.randomUUID().toString());
        try {
            CheckoutLicenseResult result = client.checkoutLicense(request);
            List entitlements = result.getEntitlementsAllowed().stream().map(EntitlementData::getName).collect(Collectors.toList());
            if (entitlements.contains(AWS_MARKETPLACE_USAGE_ENTITLEMENT_NAME)) {
                return true;
            }
        }
        catch (SdkBaseException ex) {
            LOGGER.error("Entitlement check failed with exception" + ExceptionUtils.getStackTrace(ex));
        }
        return false;
    }

    private static EntitlementData getMarketplaceUsageEntitlement() {
        return new EntitlementData().withName(AWS_MARKETPLACE_USAGE_ENTITLEMENT_NAME).withUnit(EntitlementDataUnit.None);
    }
}

