/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.integ.providers;

import com.amazonaws.appflow.custom.connector.integ.data.CustomConnectorConfiguration;
import com.amazonaws.appflow.custom.connector.integ.data.CustomConnectorProfileConfiguration;
import com.amazonaws.appflow.custom.connector.integ.data.DescribeConnectorEntityTestConfiguration;
import com.amazonaws.appflow.custom.connector.integ.data.ListConnectorEntitiesTestConfiguration;
import com.amazonaws.appflow.custom.connector.integ.data.OnDemandFromS3TestConfiguration;
import com.amazonaws.appflow.custom.connector.integ.data.OnDemandToS3TestConfiguration;
import com.amazonaws.appflow.custom.connector.integ.data.TestBucketConfiguration;
import com.amazonaws.appflow.custom.connector.integ.providers.AuthenticationType;
import com.amazonaws.appflow.custom.connector.integ.providers.CredentialsProvider;
import com.amazonaws.appflow.custom.connector.integ.providers.ResourceInfoProvider;
import com.amazonaws.services.appflow.model.ConnectionMode;
import com.amazonaws.services.appflow.model.ConnectorOperator;
import com.amazonaws.services.appflow.model.ConnectorProfileConfig;
import com.amazonaws.services.appflow.model.ConnectorProfileCredentials;
import com.amazonaws.services.appflow.model.ConnectorProfileProperties;
import com.amazonaws.services.appflow.model.ConnectorProvisioningConfig;
import com.amazonaws.services.appflow.model.ConnectorProvisioningType;
import com.amazonaws.services.appflow.model.ConnectorType;
import com.amazonaws.services.appflow.model.CreateConnectorProfileRequest;
import com.amazonaws.services.appflow.model.CreateFlowRequest;
import com.amazonaws.services.appflow.model.CustomConnectorDestinationProperties;
import com.amazonaws.services.appflow.model.CustomConnectorProfileProperties;
import com.amazonaws.services.appflow.model.CustomConnectorSourceProperties;
import com.amazonaws.services.appflow.model.DescribeConnectorEntityRequest;
import com.amazonaws.services.appflow.model.DescribeConnectorRequest;
import com.amazonaws.services.appflow.model.DestinationConnectorProperties;
import com.amazonaws.services.appflow.model.DestinationFlowConfig;
import com.amazonaws.services.appflow.model.ErrorHandlingConfig;
import com.amazonaws.services.appflow.model.FileType;
import com.amazonaws.services.appflow.model.LambdaConnectorProvisioningConfig;
import com.amazonaws.services.appflow.model.ListConnectorEntitiesRequest;
import com.amazonaws.services.appflow.model.Operator;
import com.amazonaws.services.appflow.model.RegisterConnectorRequest;
import com.amazonaws.services.appflow.model.S3ConnectorOperator;
import com.amazonaws.services.appflow.model.S3DestinationProperties;
import com.amazonaws.services.appflow.model.S3OutputFormatConfig;
import com.amazonaws.services.appflow.model.S3SourceProperties;
import com.amazonaws.services.appflow.model.SourceConnectorProperties;
import com.amazonaws.services.appflow.model.SourceFlowConfig;
import com.amazonaws.services.appflow.model.Task;
import com.amazonaws.services.appflow.model.TaskType;
import com.amazonaws.services.appflow.model.TriggerConfig;
import com.amazonaws.services.appflow.model.TriggerType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class RequestProvider {
    private final ResourceInfoProvider resourceInfoProvider;
    private final TestBucketConfiguration testBucketConfiguration;

    public RequestProvider(ResourceInfoProvider resourceInfoProvider, TestBucketConfiguration testBucketConfiguration) {
        this.resourceInfoProvider = resourceInfoProvider;
        this.testBucketConfiguration = testBucketConfiguration;
    }

    public RegisterConnectorRequest getRegisterConnectorRequest(CustomConnectorConfiguration configuration) {
        RegisterConnectorRequest request = new RegisterConnectorRequest().withConnectorLabel(this.resourceInfoProvider.generateConnectorName(configuration.name())).withConnectorProvisioningType(ConnectorProvisioningType.LAMBDA).withConnectorProvisioningConfig(new ConnectorProvisioningConfig().withLambda(new LambdaConnectorProvisioningConfig().withLambdaArn(configuration.lambdaArn())));
        return request;
    }

    public DescribeConnectorRequest getDescribeConnectorRequest(CustomConnectorConfiguration configuration) {
        DescribeConnectorRequest request = new DescribeConnectorRequest().withConnectorLabel(this.resourceInfoProvider.generateConnectorName(configuration.name())).withConnectorType(ConnectorType.CustomConnector);
        return request;
    }

    public CreateConnectorProfileRequest getCreateConnectorProfileRequest(CustomConnectorProfileConfiguration profileConfiguration) {
        CreateConnectorProfileRequest request = new CreateConnectorProfileRequest().withConnectorLabel(this.resourceInfoProvider.getConnectorName(profileConfiguration.connectorName())).withConnectorProfileName(this.resourceInfoProvider.generateProfileName(profileConfiguration.name())).withConnectorType(ConnectorType.CustomConnector).withConnectionMode(ConnectionMode.Public).withConnectorProfileConfig(new ConnectorProfileConfig().withConnectorProfileProperties(this.getConnectorProfileProperties(profileConfiguration)).withConnectorProfileCredentials(new ConnectorProfileCredentials().withCustomConnector(CredentialsProvider.getCustomConnectorProfileCredentials(profileConfiguration))));
        return request;
    }

    private ConnectorProfileProperties getConnectorProfileProperties(CustomConnectorProfileConfiguration profileConfiguration) {
        CustomConnectorProfileProperties customConnectorProfileProperties = new CustomConnectorProfileProperties();
        profileConfiguration.profileProperties().ifPresent(customConnectorProfileProperties::withProfileProperties);
        if (AuthenticationType.OAUTH2.equals((Object)profileConfiguration.authenticationType())) {
            if (!profileConfiguration.oAuth2Properties().isPresent()) {
                throw new RuntimeException("For OAuth2, oAuth2Properties are required in test-config.json");
            }
            profileConfiguration.oAuth2Properties().ifPresent(customConnectorProfileProperties::setOAuth2Properties);
        }
        return new ConnectorProfileProperties().withCustomConnector(customConnectorProfileProperties);
    }

    public DescribeConnectorEntityRequest getDescribeConnectorEntityRequest(DescribeConnectorEntityTestConfiguration configuration) {
        DescribeConnectorEntityRequest request = new DescribeConnectorEntityRequest().withConnectorProfileName(this.resourceInfoProvider.getProfileName(configuration.profileName())).withConnectorType(ConnectorType.CustomConnector).withApiVersion(this.resourceInfoProvider.getApiForProfileName(configuration.profileName(), configuration.apiVersion())).withConnectorEntityName(configuration.entityName());
        return request;
    }

    public ListConnectorEntitiesRequest getListConnectorEntitiesRequest(ListConnectorEntitiesTestConfiguration configuration) {
        return new ListConnectorEntitiesRequest().withConnectorProfileName(this.resourceInfoProvider.getProfileName(configuration.profileName())).withConnectorType(ConnectorType.CustomConnector).withEntitiesPath(configuration.entitiesPath().orElse(null)).withApiVersion(this.resourceInfoProvider.getApiForProfileName(configuration.profileName(), configuration.apiVersion()));
    }

    public CreateFlowRequest getDestinationCreateFlowRequest(OnDemandFromS3TestConfiguration configuration, List<String> fields) {
        SourceFlowConfig sourceFlowConfig = new SourceFlowConfig().withConnectorType(ConnectorType.S3).withSourceConnectorProperties(new SourceConnectorProperties().withS3(new S3SourceProperties().withBucketName(this.testBucketConfiguration.bucketName()).withBucketPrefix(this.testBucketConfiguration.bucketPrefix() + configuration.flowName())));
        DestinationFlowConfig destinationFlowConfig = new DestinationFlowConfig().withConnectorType(ConnectorType.CustomConnector).withConnectorProfileName(this.resourceInfoProvider.getProfileName(configuration.profileName())).withApiVersion(this.resourceInfoProvider.getApiForProfileName(configuration.profileName(), configuration.apiVersion())).withDestinationConnectorProperties(new DestinationConnectorProperties().withCustomConnector(new CustomConnectorDestinationProperties().withEntityName(configuration.entityName()).withWriteOperationType(configuration.writeOperationType()).withIdFieldNames((Collection<String>)configuration.idFieldNames().orElse(null)).withErrorHandlingConfig(new ErrorHandlingConfig().withFailOnFirstDestinationError(false).withBucketName(this.testBucketConfiguration.bucketName()).withBucketPrefix(this.testBucketConfiguration.bucketPrefix() + "integ-test-errors/")).withCustomProperties(configuration.destinationRuntimeSettings().orElse(null))));
        TriggerConfig triggerConfig = new TriggerConfig().withTriggerType(TriggerType.OnDemand);
        CreateFlowRequest flowRequest = new CreateFlowRequest().withDescription("Flow Created by IntegrationTestFramework.").withFlowName(this.resourceInfoProvider.generateFlowName(configuration.flowName())).withDestinationFlowConfigList(Collections.singletonList(destinationFlowConfig)).withSourceFlowConfig(sourceFlowConfig).withTasks(this.getDestinationQueryTasks(fields)).withTriggerConfig(triggerConfig);
        return flowRequest;
    }

    public CreateFlowRequest getSourceCreateFlowRequest(OnDemandToS3TestConfiguration configuration) {
        CustomConnectorSourceProperties sourceProperties = new CustomConnectorSourceProperties().withEntityName(configuration.entityName()).withCustomProperties(configuration.sourceRuntimeProperties().orElse(null));
        SourceFlowConfig sourceFlowConfig = new SourceFlowConfig().withConnectorType(ConnectorType.CustomConnector).withConnectorProfileName(this.resourceInfoProvider.getProfileName(configuration.profileName())).withApiVersion(this.resourceInfoProvider.getApiForProfileName(configuration.profileName(), configuration.apiVersion())).withSourceConnectorProperties(new SourceConnectorProperties().withCustomConnector(sourceProperties));
        DestinationFlowConfig destinationFlowConfig = this.getQueryDestinationFlowConfig();
        TriggerConfig triggerConfig = new TriggerConfig().withTriggerType(TriggerType.OnDemand);
        CreateFlowRequest flowRequest = new CreateFlowRequest().withDescription("Flow Created by IntegrationTestFramework.").withFlowName(this.resourceInfoProvider.generateFlowName(configuration.flowName())).withDestinationFlowConfigList(Collections.singletonList(destinationFlowConfig)).withSourceFlowConfig(sourceFlowConfig).withTasks(this.getQueryTasks(configuration.entityFields())).withTriggerConfig(triggerConfig);
        return flowRequest;
    }

    private DestinationFlowConfig getQueryDestinationFlowConfig() {
        DestinationConnectorProperties destinationConnectorProperties = new DestinationConnectorProperties().withS3(new S3DestinationProperties().withBucketName(this.testBucketConfiguration.bucketName()).withBucketPrefix(this.testBucketConfiguration.bucketPrefix()).withS3OutputFormatConfig(new S3OutputFormatConfig().withFileType(FileType.CSV)));
        return new DestinationFlowConfig().withConnectorType(ConnectorType.S3).withConnectorProfileName("test").withDestinationConnectorProperties(destinationConnectorProperties);
    }

    private List<Task> getQueryTasks(List<String> fields) {
        List<Task> tasks = fields.stream().map(it -> new Task().withTaskType(TaskType.Map).withConnectorOperator(new ConnectorOperator().withS3(S3ConnectorOperator.NO_OP)).withTaskProperties(Collections.emptyMap()).withSourceFields((String)it).withDestinationField((String)it)).collect(Collectors.toList());
        tasks.add(new Task().withTaskType(TaskType.Filter).withTaskProperties(Collections.emptyMap()).withConnectorOperator(new ConnectorOperator().withCustomConnector(Operator.PROJECTION)).withSourceFields(fields));
        return tasks;
    }

    private List<Task> getDestinationQueryTasks(List<String> fields) {
        List<Task> tasks = fields.stream().map(it -> new Task().withTaskType(TaskType.Map).withConnectorOperator(new ConnectorOperator().withS3(S3ConnectorOperator.NO_OP)).withTaskProperties(Collections.emptyMap()).withSourceFields((String)it).withDestinationField((String)it)).collect(Collectors.toList());
        tasks.add(new Task().withTaskType(TaskType.Filter).withTaskProperties(Collections.emptyMap()).withConnectorOperator(new ConnectorOperator().withS3(S3ConnectorOperator.PROJECTION)).withSourceFields(fields));
        return tasks;
    }
}

