/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.example.handler;

import com.amazonaws.appflow.custom.connector.example.configuration.SalesforceConnectorConfiguration;
import com.amazonaws.appflow.custom.connector.example.handler.SalesforceMetadataHandler;
import com.amazonaws.appflow.custom.connector.handlers.ConfigurationHandler;
import com.amazonaws.appflow.custom.connector.model.ImmutableConnectorContext;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.DescribeConnectorConfigurationRequest;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.DescribeConnectorConfigurationResponse;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.ImmutableDescribeConnectorConfigurationResponse;
import com.amazonaws.appflow.custom.connector.model.credentials.ImmutableValidateCredentialsResponse;
import com.amazonaws.appflow.custom.connector.model.credentials.ValidateCredentialsRequest;
import com.amazonaws.appflow.custom.connector.model.credentials.ValidateCredentialsResponse;
import com.amazonaws.appflow.custom.connector.model.metadata.ImmutableListEntitiesRequest;
import com.amazonaws.appflow.custom.connector.model.metadata.ListEntitiesResponse;
import com.amazonaws.appflow.custom.connector.model.settings.ImmutableValidateConnectorRuntimeSettingsResponse;
import com.amazonaws.appflow.custom.connector.model.settings.ValidateConnectorRuntimeSettingsRequest;
import com.amazonaws.appflow.custom.connector.model.settings.ValidateConnectorRuntimeSettingsResponse;
import java.util.Objects;

public class SalesforceConfigurationHandler
implements ConfigurationHandler {
    private static final String CONNECTOR_OWNER = "SampleConnector";
    private static final String CONNECTOR_NAME = "SampleSalesforceConnector";
    private static final String CONNECTOR_VERSION = "1.0";

    @Override
    public ValidateConnectorRuntimeSettingsResponse validateConnectorRuntimeSettings(ValidateConnectorRuntimeSettingsRequest request) {
        return ImmutableValidateConnectorRuntimeSettingsResponse.builder().isSuccess(true).build();
    }

    @Override
    public ValidateCredentialsResponse validateCredentials(ValidateCredentialsRequest request) {
        ImmutableListEntitiesRequest listEntitiesRequest = ImmutableListEntitiesRequest.builder().connectorContext(ImmutableConnectorContext.builder().apiVersion(request.connectorRuntimeSettings().get("api_version")).credentials(request.credentials()).connectorRuntimeSettings(request.connectorRuntimeSettings()).build()).build();
        ListEntitiesResponse response = new SalesforceMetadataHandler().listEntities(listEntitiesRequest);
        if (Objects.nonNull(response.errorDetails())) {
            return ImmutableValidateCredentialsResponse.builder().isSuccess(false).errorDetails(response.errorDetails()).build();
        }
        return ImmutableValidateCredentialsResponse.builder().isSuccess(true).build();
    }

    @Override
    public DescribeConnectorConfigurationResponse describeConnectorConfiguration(DescribeConnectorConfigurationRequest request) {
        return ImmutableDescribeConnectorConfigurationResponse.builder().isSuccess(true).connectorOwner(CONNECTOR_OWNER).connectorName(CONNECTOR_NAME).connectorVersion(CONNECTOR_VERSION).connectorModes(SalesforceConnectorConfiguration.getConnectorModes()).connectorRuntimeSetting(SalesforceConnectorConfiguration.getConnectorRuntimeSettings()).authenticationConfig(SalesforceConnectorConfiguration.getAuthenticationConfig()).supportedApiVersions(SalesforceConnectorConfiguration.getSupportedApiVersions()).supportedWriteOperations(SalesforceConnectorConfiguration.supportedWriteOperations()).build();
    }
}

