/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread.graph;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.testng.IDynamicGraph;
import org.testng.TestNGException;
import org.testng.collections.Maps;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.thread.TestNGThreadFactory;
import org.testng.log4testng.Logger;
import org.testng.thread.ITestNGThreadPoolExecutor;
import org.testng.thread.IThreadWorkerFactory;
import org.testng.thread.IWorker;

public class GraphThreadPoolExecutor<T>
extends ThreadPoolExecutor
implements ITestNGThreadPoolExecutor {
    private final IDynamicGraph<T> m_graph;
    private final IThreadWorkerFactory<T> m_factory;
    private final Map<T, IWorker<T>> mapping = Maps.newConcurrentMap();
    private final Map<T, T> upstream = Maps.newConcurrentMap();
    private final Comparator<T> m_comparator;

    public GraphThreadPoolExecutor(String name, IDynamicGraph<T> graph, IThreadWorkerFactory<T> factory, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, Comparator<T> comparator) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new TestNGThreadFactory(name));
        this.m_graph = graph;
        this.m_factory = factory;
        this.m_comparator = comparator;
        if (this.m_graph.getFreeNodes().isEmpty()) {
            throw new TestNGException("The graph of methods contains a cycle:" + graph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        IDynamicGraph<T> iDynamicGraph = this.m_graph;
        synchronized (iDynamicGraph) {
            List<T> freeNodes = this.m_graph.getFreeNodes();
            if (this.m_comparator != null) {
                freeNodes.sort(this.m_comparator);
            }
            this.runNodes(freeNodes);
        }
    }

    private void runNodes(List<T> freeNodes) {
        List<IWorker<T>> workers = this.m_factory.createWorkers(freeNodes);
        this.mapNodeToWorker(workers, freeNodes);
        for (int ix = 0; ix < workers.size(); ++ix) {
            IWorker<T> worker = workers.get(ix);
            this.mapNodeToParent(freeNodes);
            this.setStatus(worker, IDynamicGraph.Status.RUNNING);
            try {
                this.execute(worker);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(GraphThreadPoolExecutor.class).error(ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterExecute(Runnable r, Throwable t) {
        IDynamicGraph<T> iDynamicGraph = this.m_graph;
        synchronized (iDynamicGraph) {
            this.setStatus((IWorker)r, this.computeStatus(r));
            if (this.m_graph.getNodeCount() == this.m_graph.getNodeCountWithStatus(IDynamicGraph.Status.FINISHED)) {
                this.shutdown();
            } else {
                List<T> freeNodes = this.m_graph.getFreeNodes();
                if (this.m_comparator != null) {
                    freeNodes.sort(this.m_comparator);
                }
                this.handleThreadAffinity(freeNodes);
                this.runNodes(freeNodes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(IWorker<T> worker, IDynamicGraph.Status status) {
        IDynamicGraph<T> iDynamicGraph = this.m_graph;
        synchronized (iDynamicGraph) {
            for (T m3 : worker.getTasks()) {
                this.m_graph.setStatus(m3, status);
            }
        }
    }

    private IDynamicGraph.Status computeStatus(Runnable r) {
        IWorker worker = (IWorker)r;
        IDynamicGraph.Status status = IDynamicGraph.Status.FINISHED;
        if (RuntimeBehavior.enforceThreadAffinity() && !worker.completed()) {
            status = IDynamicGraph.Status.READY;
        }
        return status;
    }

    private void mapNodeToWorker(List<IWorker<T>> runnables, List<T> freeNodes) {
        if (!RuntimeBehavior.enforceThreadAffinity()) {
            return;
        }
        for (IWorker<T> runnable : runnables) {
            for (T freeNode : freeNodes) {
                IWorker<T> w = this.mapping.get(freeNode);
                if (w != null) {
                    long current = w.getThreadIdToRunOn();
                    runnable.setThreadIdToRunOn(current);
                }
                if (!runnable.toString().contains(freeNode.toString())) continue;
                this.mapping.put(freeNode, runnable);
            }
        }
    }

    private void mapNodeToParent(List<T> freeNodes) {
        if (!RuntimeBehavior.enforceThreadAffinity()) {
            return;
        }
        for (T freeNode : freeNodes) {
            List<Object> nodes = this.m_graph.getDependenciesFor(freeNode);
            nodes.forEach(eachNode -> this.upstream.put(eachNode, freeNode));
        }
    }

    private void handleThreadAffinity(List<T> freeNodes) {
        if (!RuntimeBehavior.enforceThreadAffinity()) {
            return;
        }
        for (T node : freeNodes) {
            IWorker<T> w;
            T upstreamNode = this.upstream.get(node);
            if (upstreamNode == null || (w = this.mapping.get(upstreamNode)) == null) continue;
            long threadId = w.getCurrentThreadId();
            this.mapping.put(node, new PhoneyWorker(threadId));
        }
    }

    private class PhoneyWorker
    implements IWorker<T> {
        private long threadId;

        public PhoneyWorker(long threadId) {
            this.threadId = threadId;
        }

        @Override
        public List<T> getTasks() {
            return null;
        }

        @Override
        public long getTimeOut() {
            return 0L;
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public int compareTo(@Nonnull IWorker<T> o) {
            return 0;
        }

        @Override
        public void run() {
        }

        @Override
        public long getThreadIdToRunOn() {
            return this.threadId;
        }
    }
}

