/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import org.testng.IClass;
import org.testng.ITest;
import org.testng.ITestClass;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.IParameterInfo;
import org.testng.internal.ITestClassConfigInfo;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.TestNGMethod;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.log4testng.Logger;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

class TestClass
extends NoOpTestClass
implements ITestClass,
ITestClassConfigInfo {
    private IAnnotationFinder annotationFinder = null;
    private ITestMethodFinder testMethodFinder = null;
    private IClass iClass = null;
    private String testName;
    private XmlTest xmlTest;
    private XmlClass xmlClass;
    private final ITestObjectFactory objectFactory;
    private final String m_errorMsgPrefix;
    private final IdentityHashMap<Object, List<ITestNGMethod>> beforeClassConfig = new IdentityHashMap();
    private static final Logger LOG = Logger.getLogger(TestClass.class);

    @Override
    public List<ITestNGMethod> getAllBeforeClassMethods() {
        return this.beforeClassConfig.values().parallelStream().reduce((a, b) -> {
            ArrayList methodList = new ArrayList(a);
            methodList.addAll(b);
            return methodList;
        }).orElse(Lists.newArrayList());
    }

    @Override
    public List<ITestNGMethod> getInstanceBeforeClassMethods(Object instance) {
        return this.beforeClassConfig.get(instance);
    }

    protected TestClass(ITestObjectFactory objectFactory, IClass cls, ITestMethodFinder testMethodFinder, IAnnotationFinder annotationFinder, XmlTest xmlTest, XmlClass xmlClass, String errorMsgPrefix) {
        this.objectFactory = objectFactory;
        this.m_errorMsgPrefix = errorMsgPrefix;
        this.init(cls, testMethodFinder, annotationFinder, xmlTest, xmlClass);
    }

    @Override
    public String getTestName() {
        return this.testName;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.xmlTest;
    }

    @Override
    public XmlClass getXmlClass() {
        return this.xmlClass;
    }

    public IAnnotationFinder getAnnotationFinder() {
        return this.annotationFinder;
    }

    private void init(IClass cls, ITestMethodFinder testMethodFinder, IAnnotationFinder annotationFinder, XmlTest xmlTest, XmlClass xmlClass) {
        this.log(3, "Creating TestClass for " + cls);
        this.iClass = cls;
        this.m_testClass = cls.getRealClass();
        this.xmlTest = xmlTest;
        this.xmlClass = xmlClass;
        this.testMethodFinder = testMethodFinder;
        this.annotationFinder = annotationFinder;
        this.initTestClassesAndInstances();
        this.initMethods();
    }

    private void initTestClassesAndInstances() {
        Object[] instances;
        for (Object instance : instances = this.getInstances(true, this.m_errorMsgPrefix)) {
            if (!((instance = IParameterInfo.embeddedInstance(instance)) instanceof ITest)) continue;
            this.testName = ((ITest)instance).getTestName();
            break;
        }
        if (this.testName == null) {
            this.testName = this.iClass.getTestName();
        }
    }

    @Override
    public Object[] getInstances(boolean create) {
        return this.iClass.getInstances(create);
    }

    @Override
    public Object[] getInstances(boolean create, String errorMsgPrefix) {
        return this.iClass.getInstances(create, this.m_errorMsgPrefix);
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.iClass.getInstanceHashCodes();
    }

    @Override
    public void addInstance(Object instance) {
        this.iClass.addInstance(instance);
    }

    private void initMethods() {
        ITestNGMethod[] methods = this.testMethodFinder.getTestMethods(this.m_testClass, this.xmlTest);
        this.m_testMethods = this.createTestMethods(methods);
        for (Object eachInstance : this.iClass.getInstances(false)) {
            this.m_beforeSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.objectFactory, this.testMethodFinder.getBeforeSuiteMethods(this.m_testClass), this.annotationFinder, true, eachInstance);
            this.m_afterSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.objectFactory, this.testMethodFinder.getAfterSuiteMethods(this.m_testClass), this.annotationFinder, false, eachInstance);
            this.m_beforeTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.objectFactory, this.testMethodFinder.getBeforeTestConfigurationMethods(this.m_testClass), this.annotationFinder, true, this.xmlTest, eachInstance);
            this.m_afterTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.objectFactory, this.testMethodFinder.getAfterTestConfigurationMethods(this.m_testClass), this.annotationFinder, false, this.xmlTest, eachInstance);
            this.m_beforeClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.objectFactory, this.testMethodFinder.getBeforeClassMethods(this.m_testClass), this.annotationFinder, true, this.xmlTest, eachInstance);
            Object instance = IParameterInfo.embeddedInstance(eachInstance);
            this.beforeClassConfig.put(instance, Arrays.asList(this.m_beforeClassMethods));
            this.m_afterClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.objectFactory, this.testMethodFinder.getAfterClassMethods(this.m_testClass), this.annotationFinder, false, this.xmlTest, eachInstance);
            this.m_beforeGroupsMethods = ConfigurationMethod.createBeforeConfigurationMethods(this.objectFactory, this.testMethodFinder.getBeforeGroupsConfigurationMethods(this.m_testClass), this.annotationFinder, true, eachInstance);
            this.m_afterGroupsMethods = ConfigurationMethod.createAfterConfigurationMethods(this.objectFactory, this.testMethodFinder.getAfterGroupsConfigurationMethods(this.m_testClass), this.annotationFinder, false, eachInstance);
            this.m_beforeTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods(this.objectFactory, this.testMethodFinder.getBeforeTestMethods(this.m_testClass), this.annotationFinder, true, this.xmlTest, eachInstance);
            this.m_afterTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods(this.objectFactory, this.testMethodFinder.getAfterTestMethods(this.m_testClass), this.annotationFinder, false, this.xmlTest, eachInstance);
        }
    }

    private ITestNGMethod[] createTestMethods(ITestNGMethod[] methods) {
        List vResult = Lists.newArrayList();
        for (ITestNGMethod tm : methods) {
            ConstructorOrMethod m3 = tm.getConstructorOrMethod();
            if (m3.getDeclaringClass().isAssignableFrom(this.m_testClass)) {
                for (Object o : this.iClass.getInstances(false)) {
                    this.log(4, "Adding method " + tm + " on TestClass " + this.m_testClass);
                    vResult.add(new TestNGMethod(this.objectFactory, m3.getMethod(), this.annotationFinder, this.xmlTest, o));
                }
                continue;
            }
            this.log(4, "Rejecting method " + tm + " for TestClass " + this.m_testClass);
        }
        return vResult.toArray(new ITestNGMethod[0]);
    }

    public ITestMethodFinder getTestMethodFinder() {
        return this.testMethodFinder;
    }

    private void log(int level, String s2) {
        Utils.log("TestClass", level, s2);
    }

    protected void dump() {
        LOG.info("===== Test class\n" + this.m_testClass.getName());
        for (ITestNGMethod m3 : this.m_beforeClassMethods) {
            LOG.info("  @BeforeClass " + m3);
        }
        for (ITestNGMethod m3 : this.m_beforeTestMethods) {
            LOG.info("  @BeforeMethod " + m3);
        }
        for (ITestNGMethod m3 : this.m_testMethods) {
            LOG.info("    @Test " + m3);
        }
        for (ITestNGMethod m3 : this.m_afterTestMethods) {
            LOG.info("  @AfterMethod " + m3);
        }
        for (ITestNGMethod m3 : this.m_afterClassMethods) {
            LOG.info("  @AfterClass " + m3);
        }
        LOG.info("======");
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("name", this.m_testClass).toString();
    }

    public IClass getIClass() {
        return this.iClass;
    }
}

