/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.collections.Maps;
import org.testng.internal.XmlMethodSelector;

public class ClassMethodMap {
    private final Map<Object, Collection<ITestNGMethod>> classMap = Maps.newConcurrentMap();
    private final Map<ITestClass, Set<Object>> beforeClassMethods = Maps.newConcurrentMap();
    private final Map<ITestClass, Set<Object>> afterClassMethods = Maps.newConcurrentMap();

    public ClassMethodMap(List<ITestNGMethod> methods, XmlMethodSelector xmlMethodSelector) {
        for (ITestNGMethod m3 : methods) {
            if (xmlMethodSelector != null && !xmlMethodSelector.includeMethod(null, m3, true)) continue;
            Object instance = m3.getInstance();
            Collection<ITestNGMethod> l = this.classMap.get(instance);
            if (l == null) {
                l = new ConcurrentLinkedQueue<ITestNGMethod>();
                this.classMap.put(instance, l);
            }
            l.add(m3);
        }
    }

    public boolean removeAndCheckIfLast(ITestNGMethod m3, Object instance) {
        Collection<ITestNGMethod> l = this.classMap.get(instance);
        if (l == null) {
            throw new AssertionError((Object)"l should not be null");
        }
        l.remove(m3);
        for (ITestNGMethod tm : l) {
            if (!tm.getEnabled() || !tm.getTestClass().equals(m3.getTestClass())) continue;
            return false;
        }
        return true;
    }

    public Map<ITestClass, Set<Object>> getInvokedBeforeClassMethods() {
        return this.beforeClassMethods;
    }

    public Map<ITestClass, Set<Object>> getInvokedAfterClassMethods() {
        return this.afterClassMethods;
    }

    public void clear() {
        for (Set<Object> instances : this.beforeClassMethods.values()) {
            instances.clear();
        }
        for (Set<Object> instances : this.afterClassMethods.values()) {
            instances.clear();
        }
        this.beforeClassMethods.clear();
        this.afterClassMethods.clear();
    }
}

