/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.TokenData;
import java.util.List;

@SdkInternalApi
public class TokenDataMarshaller {
    private static final MarshallingInfo<String> TOKENID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TokenId").build();
    private static final MarshallingInfo<String> TOKENTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TokenType").build();
    private static final MarshallingInfo<String> LICENSEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LicenseArn").build();
    private static final MarshallingInfo<String> EXPIRATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationTime").build();
    private static final MarshallingInfo<List> TOKENPROPERTIES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TokenProperties").build();
    private static final MarshallingInfo<List> ROLEARNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArns").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final TokenDataMarshaller instance = new TokenDataMarshaller();

    public static TokenDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(TokenData tokenData, ProtocolMarshaller protocolMarshaller) {
        if (tokenData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(tokenData.getTokenId(), TOKENID_BINDING);
            protocolMarshaller.marshall(tokenData.getTokenType(), TOKENTYPE_BINDING);
            protocolMarshaller.marshall(tokenData.getLicenseArn(), LICENSEARN_BINDING);
            protocolMarshaller.marshall(tokenData.getExpirationTime(), EXPIRATIONTIME_BINDING);
            protocolMarshaller.marshall(tokenData.getTokenProperties(), TOKENPROPERTIES_BINDING);
            protocolMarshaller.marshall(tokenData.getRoleArns(), ROLEARNS_BINDING);
            protocolMarshaller.marshall(tokenData.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

