/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.licensemanager.model.ConsumptionConfiguration;
import com.amazonaws.services.licensemanager.model.DatetimeRange;
import com.amazonaws.services.licensemanager.model.Entitlement;
import com.amazonaws.services.licensemanager.model.Issuer;
import com.amazonaws.services.licensemanager.model.Metadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateLicenseRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String licenseName;
    private String productName;
    private String productSKU;
    private Issuer issuer;
    private String homeRegion;
    private DatetimeRange validity;
    private List<Entitlement> entitlements;
    private String beneficiary;
    private ConsumptionConfiguration consumptionConfiguration;
    private List<Metadata> licenseMetadata;
    private String clientToken;

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public CreateLicenseRequest withLicenseName(String licenseName) {
        this.setLicenseName(licenseName);
        return this;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductName() {
        return this.productName;
    }

    public CreateLicenseRequest withProductName(String productName) {
        this.setProductName(productName);
        return this;
    }

    public void setProductSKU(String productSKU) {
        this.productSKU = productSKU;
    }

    public String getProductSKU() {
        return this.productSKU;
    }

    public CreateLicenseRequest withProductSKU(String productSKU) {
        this.setProductSKU(productSKU);
        return this;
    }

    public void setIssuer(Issuer issuer) {
        this.issuer = issuer;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public CreateLicenseRequest withIssuer(Issuer issuer) {
        this.setIssuer(issuer);
        return this;
    }

    public void setHomeRegion(String homeRegion) {
        this.homeRegion = homeRegion;
    }

    public String getHomeRegion() {
        return this.homeRegion;
    }

    public CreateLicenseRequest withHomeRegion(String homeRegion) {
        this.setHomeRegion(homeRegion);
        return this;
    }

    public void setValidity(DatetimeRange validity) {
        this.validity = validity;
    }

    public DatetimeRange getValidity() {
        return this.validity;
    }

    public CreateLicenseRequest withValidity(DatetimeRange validity) {
        this.setValidity(validity);
        return this;
    }

    public List<Entitlement> getEntitlements() {
        return this.entitlements;
    }

    public void setEntitlements(Collection<Entitlement> entitlements) {
        if (entitlements == null) {
            this.entitlements = null;
            return;
        }
        this.entitlements = new ArrayList<Entitlement>(entitlements);
    }

    public CreateLicenseRequest withEntitlements(Entitlement ... entitlements) {
        if (this.entitlements == null) {
            this.setEntitlements(new ArrayList<Entitlement>(entitlements.length));
        }
        for (Entitlement ele : entitlements) {
            this.entitlements.add(ele);
        }
        return this;
    }

    public CreateLicenseRequest withEntitlements(Collection<Entitlement> entitlements) {
        this.setEntitlements(entitlements);
        return this;
    }

    public void setBeneficiary(String beneficiary) {
        this.beneficiary = beneficiary;
    }

    public String getBeneficiary() {
        return this.beneficiary;
    }

    public CreateLicenseRequest withBeneficiary(String beneficiary) {
        this.setBeneficiary(beneficiary);
        return this;
    }

    public void setConsumptionConfiguration(ConsumptionConfiguration consumptionConfiguration) {
        this.consumptionConfiguration = consumptionConfiguration;
    }

    public ConsumptionConfiguration getConsumptionConfiguration() {
        return this.consumptionConfiguration;
    }

    public CreateLicenseRequest withConsumptionConfiguration(ConsumptionConfiguration consumptionConfiguration) {
        this.setConsumptionConfiguration(consumptionConfiguration);
        return this;
    }

    public List<Metadata> getLicenseMetadata() {
        return this.licenseMetadata;
    }

    public void setLicenseMetadata(Collection<Metadata> licenseMetadata) {
        if (licenseMetadata == null) {
            this.licenseMetadata = null;
            return;
        }
        this.licenseMetadata = new ArrayList<Metadata>(licenseMetadata);
    }

    public CreateLicenseRequest withLicenseMetadata(Metadata ... licenseMetadata) {
        if (this.licenseMetadata == null) {
            this.setLicenseMetadata(new ArrayList<Metadata>(licenseMetadata.length));
        }
        for (Metadata ele : licenseMetadata) {
            this.licenseMetadata.add(ele);
        }
        return this;
    }

    public CreateLicenseRequest withLicenseMetadata(Collection<Metadata> licenseMetadata) {
        this.setLicenseMetadata(licenseMetadata);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateLicenseRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLicenseName() != null) {
            sb.append("LicenseName: ").append(this.getLicenseName()).append(",");
        }
        if (this.getProductName() != null) {
            sb.append("ProductName: ").append(this.getProductName()).append(",");
        }
        if (this.getProductSKU() != null) {
            sb.append("ProductSKU: ").append(this.getProductSKU()).append(",");
        }
        if (this.getIssuer() != null) {
            sb.append("Issuer: ").append(this.getIssuer()).append(",");
        }
        if (this.getHomeRegion() != null) {
            sb.append("HomeRegion: ").append(this.getHomeRegion()).append(",");
        }
        if (this.getValidity() != null) {
            sb.append("Validity: ").append(this.getValidity()).append(",");
        }
        if (this.getEntitlements() != null) {
            sb.append("Entitlements: ").append(this.getEntitlements()).append(",");
        }
        if (this.getBeneficiary() != null) {
            sb.append("Beneficiary: ").append(this.getBeneficiary()).append(",");
        }
        if (this.getConsumptionConfiguration() != null) {
            sb.append("ConsumptionConfiguration: ").append(this.getConsumptionConfiguration()).append(",");
        }
        if (this.getLicenseMetadata() != null) {
            sb.append("LicenseMetadata: ").append(this.getLicenseMetadata()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseRequest)) {
            return false;
        }
        CreateLicenseRequest other = (CreateLicenseRequest)obj;
        if (other.getLicenseName() == null ^ this.getLicenseName() == null) {
            return false;
        }
        if (other.getLicenseName() != null && !other.getLicenseName().equals(this.getLicenseName())) {
            return false;
        }
        if (other.getProductName() == null ^ this.getProductName() == null) {
            return false;
        }
        if (other.getProductName() != null && !other.getProductName().equals(this.getProductName())) {
            return false;
        }
        if (other.getProductSKU() == null ^ this.getProductSKU() == null) {
            return false;
        }
        if (other.getProductSKU() != null && !other.getProductSKU().equals(this.getProductSKU())) {
            return false;
        }
        if (other.getIssuer() == null ^ this.getIssuer() == null) {
            return false;
        }
        if (other.getIssuer() != null && !other.getIssuer().equals(this.getIssuer())) {
            return false;
        }
        if (other.getHomeRegion() == null ^ this.getHomeRegion() == null) {
            return false;
        }
        if (other.getHomeRegion() != null && !other.getHomeRegion().equals(this.getHomeRegion())) {
            return false;
        }
        if (other.getValidity() == null ^ this.getValidity() == null) {
            return false;
        }
        if (other.getValidity() != null && !other.getValidity().equals(this.getValidity())) {
            return false;
        }
        if (other.getEntitlements() == null ^ this.getEntitlements() == null) {
            return false;
        }
        if (other.getEntitlements() != null && !other.getEntitlements().equals(this.getEntitlements())) {
            return false;
        }
        if (other.getBeneficiary() == null ^ this.getBeneficiary() == null) {
            return false;
        }
        if (other.getBeneficiary() != null && !other.getBeneficiary().equals(this.getBeneficiary())) {
            return false;
        }
        if (other.getConsumptionConfiguration() == null ^ this.getConsumptionConfiguration() == null) {
            return false;
        }
        if (other.getConsumptionConfiguration() != null && !other.getConsumptionConfiguration().equals(this.getConsumptionConfiguration())) {
            return false;
        }
        if (other.getLicenseMetadata() == null ^ this.getLicenseMetadata() == null) {
            return false;
        }
        if (other.getLicenseMetadata() != null && !other.getLicenseMetadata().equals(this.getLicenseMetadata())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLicenseName() == null ? 0 : this.getLicenseName().hashCode());
        hashCode = 31 * hashCode + (this.getProductName() == null ? 0 : this.getProductName().hashCode());
        hashCode = 31 * hashCode + (this.getProductSKU() == null ? 0 : this.getProductSKU().hashCode());
        hashCode = 31 * hashCode + (this.getIssuer() == null ? 0 : this.getIssuer().hashCode());
        hashCode = 31 * hashCode + (this.getHomeRegion() == null ? 0 : this.getHomeRegion().hashCode());
        hashCode = 31 * hashCode + (this.getValidity() == null ? 0 : this.getValidity().hashCode());
        hashCode = 31 * hashCode + (this.getEntitlements() == null ? 0 : this.getEntitlements().hashCode());
        hashCode = 31 * hashCode + (this.getBeneficiary() == null ? 0 : this.getBeneficiary().hashCode());
        hashCode = 31 * hashCode + (this.getConsumptionConfiguration() == null ? 0 : this.getConsumptionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseMetadata() == null ? 0 : this.getLicenseMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    @Override
    public CreateLicenseRequest clone() {
        return (CreateLicenseRequest)super.clone();
    }
}

