/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.api;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.LambdaRuntime;

public class LambdaContext
implements Context {
    private int memoryLimit;
    private final String awsRequestId;
    private final String logGroupName;
    private final String logStreamName;
    private final String functionName;
    private final String functionVersion;
    private final String invokedFunctionArn;
    private final long deadlineTimeInMs;
    private final CognitoIdentity cognitoIdentity;
    private final ClientContext clientContext;
    private final LambdaLogger logger;

    public LambdaContext(int memoryLimit, long deadlineTimeInMs, String requestId, String logGroupName, String logStreamName, String functionName, CognitoIdentity identity, String functionVersion, String invokedFunctionArn, ClientContext clientContext) {
        this.memoryLimit = memoryLimit;
        this.deadlineTimeInMs = deadlineTimeInMs;
        this.awsRequestId = requestId;
        this.logGroupName = logGroupName;
        this.logStreamName = logStreamName;
        this.functionName = functionName;
        this.cognitoIdentity = identity;
        this.clientContext = clientContext;
        this.functionVersion = functionVersion;
        this.invokedFunctionArn = invokedFunctionArn;
        this.logger = LambdaRuntime.getLogger();
    }

    @Override
    public int getMemoryLimitInMB() {
        return this.memoryLimit;
    }

    @Override
    public String getAwsRequestId() {
        return this.awsRequestId;
    }

    @Override
    public String getLogGroupName() {
        return this.logGroupName;
    }

    @Override
    public String getLogStreamName() {
        return this.logStreamName;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public String getFunctionVersion() {
        return this.functionVersion;
    }

    @Override
    public String getInvokedFunctionArn() {
        return this.invokedFunctionArn;
    }

    @Override
    public CognitoIdentity getIdentity() {
        return this.cognitoIdentity;
    }

    @Override
    public ClientContext getClientContext() {
        return this.clientContext;
    }

    @Override
    public int getRemainingTimeInMillis() {
        long now = System.currentTimeMillis();
        int delta = (int)(this.deadlineTimeInMs - now);
        return delta > 0 ? delta : 0;
    }

    @Override
    public LambdaLogger getLogger() {
        return this.logger;
    }
}

