/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.services.appflow.model.Range;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class RangeJsonUnmarshaller
implements Unmarshaller<Range, JsonUnmarshallerContext> {
    private static RangeJsonUnmarshaller instance;

    @Override
    public Range unmarshall(JsonUnmarshallerContext context) throws Exception {
        Range range = new Range();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("maximum", targetDepth)) {
                    context.nextToken();
                    range.setMaximum(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("minimum", targetDepth)) {
                    context.nextToken();
                    range.setMinimum(context.getUnmarshaller(Double.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return range;
    }

    public static RangeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RangeJsonUnmarshaller();
        }
        return instance;
    }
}

