/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.services.appflow.model.AuthenticationConfig;
import com.amazonaws.services.appflow.model.CustomAuthConfig;
import com.amazonaws.services.appflow.model.transform.CustomAuthConfigJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.OAuth2DefaultsJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class AuthenticationConfigJsonUnmarshaller
implements Unmarshaller<AuthenticationConfig, JsonUnmarshallerContext> {
    private static AuthenticationConfigJsonUnmarshaller instance;

    @Override
    public AuthenticationConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        AuthenticationConfig authenticationConfig = new AuthenticationConfig();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("isBasicAuthSupported", targetDepth)) {
                    context.nextToken();
                    authenticationConfig.setIsBasicAuthSupported(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("isApiKeyAuthSupported", targetDepth)) {
                    context.nextToken();
                    authenticationConfig.setIsApiKeyAuthSupported(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("isOAuth2Supported", targetDepth)) {
                    context.nextToken();
                    authenticationConfig.setIsOAuth2Supported(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("isCustomAuthSupported", targetDepth)) {
                    context.nextToken();
                    authenticationConfig.setIsCustomAuthSupported(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("oAuth2Defaults", targetDepth)) {
                    context.nextToken();
                    authenticationConfig.setOAuth2Defaults(OAuth2DefaultsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("customAuthConfigs", targetDepth)) {
                    context.nextToken();
                    authenticationConfig.setCustomAuthConfigs(new ListUnmarshaller<CustomAuthConfig>(CustomAuthConfigJsonUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return authenticationConfig;
    }

    public static AuthenticationConfigJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AuthenticationConfigJsonUnmarshaller();
        }
        return instance;
    }
}

