/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appflow.model.ApiKeyCredentials;

@SdkInternalApi
public class ApiKeyCredentialsMarshaller {
    private static final MarshallingInfo<String> APIKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiKey").build();
    private static final MarshallingInfo<String> APISECRETKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiSecretKey").build();
    private static final ApiKeyCredentialsMarshaller instance = new ApiKeyCredentialsMarshaller();

    public static ApiKeyCredentialsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ApiKeyCredentials apiKeyCredentials, ProtocolMarshaller protocolMarshaller) {
        if (apiKeyCredentials == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(apiKeyCredentials.getApiKey(), APIKEY_BINDING);
            protocolMarshaller.marshall(apiKeyCredentials.getApiSecretKey(), APISECRETKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

