/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.queryfilter;

import com.amazonaws.appflow.custom.connector.queryfilter.InvalidFilterExpressionException;
import com.amazonaws.appflow.custom.connector.queryfilter.SyntaxErrorReporter;
import com.amazonaws.appflow.custom.connector.queryfilter.antlr.CustomConnectorQueryFilterLexer;
import com.amazonaws.appflow.custom.connector.queryfilter.antlr.CustomConnectorQueryFilterParser;
import java.util.Objects;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public final class CustomConnectorParseTreeBuilder {
    private CustomConnectorParseTreeBuilder() {
    }

    public static ParseTree parse(String filterExpression) {
        Objects.requireNonNull(filterExpression, "Filter expression can't be null");
        CodePointCharStream cs = CharStreams.fromString(filterExpression);
        CustomConnectorQueryFilterLexer customConnectorQueryFilterLexer = new CustomConnectorQueryFilterLexer(cs);
        CommonTokenStream cts = new CommonTokenStream(customConnectorQueryFilterLexer);
        CustomConnectorQueryFilterParser parser = new CustomConnectorQueryFilterParser(cts);
        parser.removeErrorListeners();
        SyntaxErrorReporter syntaxErrorReporter = new SyntaxErrorReporter();
        parser.addErrorListener(syntaxErrorReporter);
        CustomConnectorQueryFilterParser.QueryfilterContext tree = parser.queryfilter();
        if (syntaxErrorReporter.hasError()) {
            throw new InvalidFilterExpressionException("Filter expression has the following syntax errors : " + syntaxErrorReporter.getSyntaxErrors());
        }
        return tree;
    }
}

